DATE <-
"Tue Feb  2 13:44:36 2010"
VERSION <-
"4.4.0"
.onLoad <-
function( libname, pkgname ) { ##.onAttach
    cat( "Loading ", pkgname, " version ", VERSION, " (", DATE, ")\n", sep="" )
    cat( "Copyright (C) David J Reiss, Institute for Systems Biology.\n" )
    cat( "Please email dreiss@systemsbiology.org if you run into any issues.\n" )
  }

cluster.pclust <-
function (k, mot.inds = "COMBINED") 
{
    inds <- mot.inds
    if (mot.inds[1] == "COMBINED") 
        inds <- names(get("mot.weights"))
    rows <- get.rows(k)
    p.clusts <- sapply(inds, function(n) {
        pvs <- meme.scores[[n]]$all.pv
        if (is.null(pvs)) 
            return(NA)
        rows <- rows[rows %in% rownames(pvs)]
        if (length(rows) > 0) 
            mean(log10(pvs[rows, k]), na.rm = T)
        else NA
    })
    e.vals <- sapply(inds, function(n) {
        ms <- meme.scores[[n]][[k]]
        sapply(1:length(ms$meme.out), function(i) if (length(rows) > 
            0 && !is.null(ms$meme.out) && !is.null(ms$meme.out[[i]])) 
            ms$meme.out[[i]]$e.value
        else NA)
    })
    if (!is.matrix(e.vals)) 
        e.vals <- t(t(e.vals))
    if (mot.inds[1] == "COMBINED") {
        p.clusts <- weighted.mean(p.clusts, mot.weights[inds], 
            na.rm = T)
        e.vals <- apply(e.vals, 2, weighted.mean, mot.weights[inds], 
            na.rm = T)
    }
    else if (mot.inds[1] != "COMBINED") {
        if (length(p.clusts) < length(inds) && all(is.na(p.clusts))) 
            p.clusts <- rep(NA, length(inds))
        e.vals <- apply(e.vals, 1, function(i) if (length(i) < 
            length(inds) && all(is.na(i))) 
            rep(NA, length(inds))
        else i)
    }
    if (!is.matrix(e.vals)) 
        e.vals <- t(t(e.vals))
    if (is.matrix(e.vals) && ncol(e.vals) != length(inds)) 
        e.vals <- t(e.vals)
    if (mot.inds[1] != "COMBINED") 
        names(p.clusts) <- colnames(e.vals) <- inds
    else e.vals <- as.vector(e.vals)
    list(p.clusts = p.clusts, e.vals = e.vals)
}
cluster.resid <-
function (k, rats.inds = "COMBINED", varNorm = F, in.cols = T) 
{
    inds <- rats.inds
    if (rats.inds[1] == "COMBINED") 
        inds <- names(get("resid.weights"))
    resids <- sapply(ratios[inds], function(rn) {
        if (in.cols) 
            residual.submatrix(rn, get.rows(k), get.cols(k), 
                varNorm = varNorm)
        else residual.submatrix(rn, get.rows(k), colnames(rn)[!colnames(rn) %in% 
            get.cols(k)], varNorm = varNorm)
    })
    if (rats.inds[1] == "COMBINED") 
        resids <- weighted.mean(resids, resid.weights[inds], 
            na.rm = T)
    if (rats.inds[1] != "COMBINED" && length(resids) < length(inds) && 
        all(is.na(resids))) {
        resids <- rep(NA, length(inds))
        names(resids) <- inds
    }
    resids
}
cluster.summary <-
function (e.cutoff = 0.01, nrow.cutoff = 5, seq.type = "upstream", 
    plot = F, sort = c("score", "resid", "e.value1", "e.value2", 
        "nrow"), ...) 
{
    ms <- meme.scores[[seq.type]]
    out <- data.frame(nrow = tabulate(unlist(apply(row.membership, 
        1, unique)), k.clust), score = sapply(1:k.clust, function(k) mean(r.scores[get.rows(k), 
        k], na.rm = T)), resid = sapply(1:k.clust, cluster.resid, 
        varNorm = T), consensus1 = sapply(1:k.clust, function(k) if (length(ms[[k]]) <= 
        2) 
        ""
    else pssm.to.string(ms[[k]]$meme.out[[1]]$pssm)), e.value1 = sapply(1:k.clust, 
        function(k) if (length(ms[[k]]) <= 2) 
            Inf
        else ms[[k]]$meme.out[[1]]$e.value), consensus2 = sapply(1:k.clust, 
        function(k) if (length(ms[[k]]) <= 2) 
            ""
        else if (length(ms[[k]]$meme.out) == 1) 
            ""
        else pssm.to.string(ms[[k]]$meme.out[[2]]$pssm)), e.value2 = sapply(1:k.clust, 
        function(k) if (length(ms[[k]]) <= 2) 
            Inf
        else if (length(ms[[k]]$meme.out) <= 1) 
            Inf
        else ms[[k]]$meme.out[[2]]$e.value))
    if (!is.na(sort[1])) 
        out <- out[order(out[[sort[1]]]), ]
    if (!is.na(e.cutoff)) 
        out <- out[out$e.value1 <= e.cutoff | out$e.value2 <= 
            e.cutoff, ]
    if (!is.na(nrow.cutoff)) 
        out <- out[out$nrow >= nrow.cutoff, ]
    if (plot) {
        plot(out$resid, log10(-log10(out$e.value1)), typ = "n")
        text(out$resid, log10(-log10(out$e.value1)), lab = out$consensus1, 
            cex = 0.7, xpd = NA, pos = 1)
        text(out$resid, log10(-log10(out$e.value1)), lab = rownames(out), 
            cex = 0.7, xpd = NA, col = "red")
    }
    out
}
clusters.w.func <-
function (func, ks = 1:k.clust, short = F, max.rows = 999, p.val = F) 
{
    if (p.val) 
        n2 <- length(grep(func, long.names, perl = T, ignore.case = T))
    mc <- get.parallel(length(ks))
    unlist(mc$apply(ks, function(i) {
        if (!p.val) {
            if (length(get.rows(i)) >= max.rows) 
                NA
            else length(grep(func, get.long.names(get.rows(i), 
                short = short), perl = T, ignore.case = T))
        }
        else {
            phyper(length(grep(func, get.long.names(get.rows(i), 
                short = short), perl = T, ignore.case = T)), 
                n2, attr(ratios, "nrow") - n2, length(get.rows(i)), 
                lower = F)/length(ks)
        }
    }))
}
clusters.w.genes <-
function (genes, ks = 1:k.clust, p.val = F) 
{
    mc <- get.parallel(length(ks))
    unlist(mc$apply(ks, function(i) {
        if (!p.val) 
            sum(get.rows(i) %in% genes)
        else phyper(sum(get.rows(i) %in% genes), length(genes), 
            attr(ratios, "nrow") - length(genes), length(get.rows(i)), 
            lower = F)/length(ks)
    }))
}
cm.version <-
"4.4.0"
cmonkey <-
function (env = NULL, ...) 
{
    if (((is.null(list(...)$dont.init) || !list(...)$dont.init) && 
        (is.null(env$dont.init) || !env$dont.init) && (!exists("dont.init") || 
        !dont.init)) || is.null(env) || is.null(env$genome.info)) {
        env <- cmonkey.init(env, ...)
    }
    else {
        if (sink.number() > 0) 
            for (i in 1:sink.number()) try(sink(), silent = T)
        if (env$save.logfile != FALSE) 
            sink(env$save.logfile, split = T, append = T)
    }
    iter <- env$iter
    while (iter <= env$n.iter) {
        env$iter <- iter
        env$cmonkey.one.iter(env)
        iter <- iter + 1
    }
    if (!is.na(env$plot.iters) && (iter %in% env$plot.iters || 
        (iter - 1) %in% env$plot.iters)) 
        try(env$plot.stats(iter, plot.clust = env$favorite.cluster()))
    env$iter <- iter <- iter - 1
    print(env$cluster.summary())
    env$time.ended <- date()
    if (sink.number() > 0) 
        for (i in 1:sink.number()) try(sink(), silent = T)
}
cmonkey.init <-
function (env = NULL, ...) 
{
    if (!exists("cmonkey.params")) 
        cmonkey.params <- new.env(hash = T)
    if (file.exists("cmonkey-funcs.R")) {
        tmp.e <- new.env(hash = T)
        sys.source("cmonkey-funcs.R", envir = tmp.e)
    }
    else {
        tmp.e <- environment(cMonkey:::cmonkey)
    }
    for (i in ls(tmp.e)) {
        f2 <- NULL
        if ((!is.null(env) && exists(i, envir = env, inherit = F))) {
            f <- try(get(i, envir = env))
            f2 <- try(get(i, envir = tmp.e))
        }
        else if (exists(i, envir = .GlobalEnv, inherit = F)) {
            f <- try(get(i, envir = .GlobalEnv))
            f2 <- try(get(i, envir = tmp.e))
        }
        else {
            f <- try(get(i, envir = tmp.e))
        }
        if (class(f) == "function") 
            environment(f) <- sys.frames()[[length(sys.frames())]]
        assign(i, f)
        if (!is.null(f2) && class(f2) == "function" && object.size(f2) != 
            object.size(f)) {
            environment(f2) <- sys.frames()[[length(sys.frames())]]
            assign(paste("super", i, sep = "."), f2)
        }
    }
    rm(f, f2, tmp.e)
    if (!is.null(env)) 
        for (i in ls(env)) assign(i, get(i, env))
    args <- mget(names(formals()), env = as.environment(-1))
    for (i in names(args)) if (!i %in% c("...", "env")) 
        set.param(i, args[[i]])
    for (i in names(list(...))) if (i != "env") 
        set.param(i, list(...)[[i]])
    rm(args)
    if (sink.number() > 0) 
        for (i in 1:sink.number()) try(sink(), silent = T)
    set.param("save.logfile", FALSE)
    if (save.logfile != FALSE) 
        sink(save.logfile, split = T, append = (exists("dont.init") && 
            dont.init) || (exists("is.inited") && !is.inited))
    if (!exists("organism")) {
        cat("WARNING: No organism was set; using \"hpy\".\n")
        organism <- "hpy"
        Sys.sleep(3)
        set.param("organism", organism)
    }
    if (!exists("ratios") && exists("resid.weights")) {
        ratios <- lapply(names(resid.weights), get)
        names(ratios) <- names(resid.weights)
    }
    if ((exists("ratios") && !is.null(ratios))) {
        if (is.matrix(ratios) || is.data.frame(ratios) || is.character(ratios)) 
            ratios <- list(ratios = load.ratios(ratios))
        else ratios <- lapply(ratios, function(r) as.matrix(load.ratios(r)))
        attr(ratios, "rnames") <- sort(unique(unlist(lapply(ratios, 
            rownames))))
        attr(ratios, "cnames") <- sort(unique(unlist(lapply(ratios, 
            colnames))))
        attr(ratios, "nrow") <- length(attr(ratios, "rnames"))
        attr(ratios, "ncol") <- length(attr(ratios, "cnames"))
        for (n in names(ratios)) {
            attr(ratios[[n]], "maxRowVar") <- mean(apply(ratios[[n]], 
                1, var, use = "pair"), na.rm = T)
            attr(ratios[[n]], "all.colVars") <- apply(ratios[[n]], 
                2, var, use = "pair", na.rm = T)
        }
        rm(n)
    }
    if (exists("is.eukaryotic") && is.eukaryotic) {
        set.param("operon.shift", FALSE)
        set.param("remove.low.complexity.subseqs", TRUE)
    }
    set.param("cog.org", "?")
    set.param("rsat.species", "?")
    set.param("n.iter", 3000)
    set.param("n.clust.per.row", 2)
    if (exists("ratios") && !is.null(ratios)) {
        set.param("k.clust", round(attr(ratios, "nrow") * n.clust.per.row/20))
    }
    else {
        set.param("k.clust", 100)
    }
    set.param("n.clust.per.col", max(50, round(k.clust/3)))
    set.param("resid.iters", seq(1, n.iter, by = 2))
    set.param("meme.iters", seq(100, n.iter, by = 100))
    set.param("mot.iters", seq(100, n.iter, by = 10))
    set.param("net.iters", seq(1, n.iter, by = 7))
    set.param("resid.scaling", 1)
    set.param("resid.weights", c(ratios = 1))
    set.param("mot.scaling", seq(0, 1, length = n.iter/2))
    set.param("mot.weights", c(upstream = 1))
    set.param("net.scaling", seq(0, 0.5, length = n.iter/2))
    set.param("net.weights", c(string = 0.5, operons = 0.5))
    set.param("grouping.weights", numeric())
    set.param("plot.iters", seq(2, n.iter, by = 25))
    set.param("post.adjust", FALSE)
    set.param("parallel.cores", TRUE)
    set.param("pareto.adjust.scalings", TRUE)
    set.param("max.changes", c(rows = 0.2, cols = 5))
    set.param("merge.cutoffs", c(n = 0.3, cor = 0.975))
    set.param("fuzzy.index", 0.75 * exp(-(1:n.iter)/(n.iter/4)))
    set.param("translation.tab", NULL)
    set.param("seed.method", c(rows = "net=string:5", cols = "best"))
    set.param("string.version", "v8.2")
    set.param("cluster.rows.allowed", c(3, 70))
    set.param("n.motifs", c(rep(1, n.iter/3), rep(2, n.iter/3)))
    set.param("motif.width.range", c(6, 24))
    set.param("meme.addl.args", "-time 600 -dna -revcomp -maxsize 9999999 -nmotifs %1$d -evt 1e9 -minw %2$d -maxw %3$d -mod zoops")
    set.param("mast.addl.args", "-ev 99999 -mev 99999 -mt 0.99 -seqp -remcorr")
    set.param("meme.consensus", "compute")
    set.param("meme.consensus.e.val.limit", 0.1)
    set.param("motif.palindrome.option", "non")
    set.param("uniquify.seqs", TRUE)
    set.param("remove.low.complexity.subseqs", TRUE)
    set.param("operon.shift", TRUE)
    set.param("meme.seqs.allowed", cluster.rows.allowed)
    set.param("bg.order", 3)
    set.param("motif.upstream.search", c(-20, 150))
    set.param("motif.upstream.scan", c(-30, 250))
    set.param("meme.cmd", "progs/meme")
    set.param("mast.cmd", "progs/mast")
    if (any(mot.scaling > 0) && (!file.exists(meme.cmd) || !file.exists(mast.cmd))) 
        stop(paste("Motif finding is requested but", meme.cmd, 
            "and/or", mast.cmd, "is not installed!"))
    set.param("rsat.urls", c("http://rsat.ccb.sickkids.ca/", 
        "http://rsat.ulb.ac.be/rsat/", "http://embnet.ccg.unam.mx/rsa-tools"))
    set.param("stats.iters", c(1, seq(5, n.iter, by = 5)))
    set.param("script.every.iter", "cm.script.every.iter.R")
    set.param("date.run", format(Sys.time(), "%y %b %d %H:%M:%S"))
    set.param("cmonkey.version", cm.version)
    set.param("session.info", unlist(list(R.version, Sys.info(), 
        Sys.getenv(), sessionInfo())), quiet = T)
    set.param("time.started", date())
    if (exists("ratios") && !is.null(ratios)) {
        set.param("cmonkey.filename", paste("cmonkey", cmonkey.version, 
            organism, paste(sapply(ratios, dim), collapse = "x"), 
            gsub(" ", "_", date.run), sep = "_"))
    }
    else {
        set.param("cmonkey.filename", paste("cmonkey", cmonkey.version, 
            organism, "0x0", gsub(" ", "_", date.run), sep = "_"))
    }
    set.param("rnd.seed", as.integer(Sys.time()))
    set.param("big.matrices", 50 * 2^20)
    for (i in c("n.motifs", "motif.width.range", "meme.addl.args", 
        "mast.addl.args", "meme.consensus", "meme.consensus.e.val.limit", 
        "motif.palindrome.option", "uniquify.seqs", "remove.low.complexity.subseqs", 
        "operon.shift", "meme.seqs.allowed", "bg.order", "motif.upstream.search", 
        "motif.upstream.scan")) {
        v <- get(i)
        if (all(names(mot.weights) %in% names(v))) 
            next
        if (is.vector(v) && length(v) > 1) 
            v <- list(upstream = v)
        else names(v)[1] <- "upstream"
        for (n in names(mot.weights)[!names(mot.weights) %in% 
            names(v)]) {
            if (is.list(v)) 
                v[[n]] <- v[[1]]
            else if (is.vector(v)) 
                v[n] <- v[1]
            names(v) <- names(mot.weights)
        }
        assign(i, v)
    }
    rm(v)
    set.seed(rnd.seed)
    if (!exists("rsat.species") || rsat.species == "?" || is.na(rsat.species)) {
        err <- dlf("data/KEGG/KEGG_taxonomy.txt", "ftp://ftp.genome.jp/pub/kegg/genes/taxonomy")
        if (class(err) != "try-error") {
            tab <- read.delim("data/KEGG/KEGG_taxonomy.txt", 
                sep = "\t", comment = "#", head = F, as.is = T)
            rsat.spec <- as.character(subset(tab, V2 == organism, 
                select = "V4", drop = T))[1]
            rm(tab)
            if (any(strsplit(rsat.spec, "")[[1]] == "(")) 
                rsat.spec <- gsub("\\s\\(.*\\)", "", rsat.spec, 
                  perl = T)
        }
        rsat.spec <- gsub(" ", "_", rsat.spec, fixed = T)
        if (require(RCurl)) {
            tmp <- strsplit(getURL(paste(rsat.urls[1], "/data/genomes/", 
                sep = "")), "\n")[[1]]
            vals <- grep(rsat.spec, tmp, fixed = T, val = T)
            if (length(vals) <= 0) {
                cat("Could not find correct organism for RSAT... will try to guess...\n")
                max.dist <- 0.5
                vals <- rep("", 2)
                while (length(vals) > 1) {
                  vals <- agrep(rsat.spec, tmp, ignore = T, max.dist = max.dist, 
                    val = T)
                  max.dist <- max.dist - 0.01
                }
                if (length(vals) == 1) {
                  rsat.spec <- strsplit(vals, "[<>/]")[[1]][8]
                  cat("Found one match:", rsat.spec, "...\n")
                  cat("If this is not correct, you're not quite out of luck -- set the 'rsat.species' parameter manually.\n")
                }
            }
        }
        set.param("rsat.species", rsat.spec, override = T)
        dlf(paste("data/STRING/species.", string.version, ".txt", 
            sep = ""), paste("http://string.embl.de/newstring_download/species.", 
            string.version, ".txt", sep = ""))
        rm(tmp, rsat.spec, err, vals)
    }
    else {
        set.param("rsat.species", rsat.species)
    }
    if (!exists("taxon.id") || taxon.id == "?" || is.na(taxon.id) || 
        length(taxon.id) <= 0) {
        fname <- dlf("data/GO/proteome2taxid", "ftp://ftp.ebi.ac.uk/pub/databases/GO/goa/proteomes/proteome2taxid")
        tab <- read.delim(gzfile("data/GO/proteome2taxid"), head = F)
        taxon.id <- subset(tab, V1 == gsub("_", " ", rsat.species))$V2
        if (length(taxon.id) <= 0) 
            taxon.id <- subset(tab, grepl(gsub("_", " ", rsat.species), 
                V1))$V2[1]
        set.param("taxon.id", taxon.id, override = T)
        rm(tab, fname)
    }
    if (!exists("cog.org") || cog.org == "?" || is.na(cog.org)) {
        tmp <- strsplit(organism, "")[[1]]
        tmp[1] <- toupper(tmp[1])
        cog.o <- paste(tmp, sep = "", collapse = "")
        set.param("cog.org", cog.o, override = T)
        rm(cog.o, tmp)
    }
    else {
        set.param("cog.org", cog.org)
    }
    cat("Organism is", organism, cog.org, rsat.species, taxon.id, 
        "\n")
    if (get.parallel(100, verbose = T)$mc) 
        on.exit(kill(children(), SIGKILL), add = T)
    if (sum(net.weights, na.rm = T) > 0) 
        net.weights <- net.weights/sum(net.weights, na.rm = T)
    if (sum(resid.weights, na.rm = T) > 0) 
        resid.weights <- resid.weights/sum(resid.weights, na.rm = T)
    if (sum(mot.weights, na.rm = T) > 0) 
        mot.weights <- mot.weights/sum(mot.weights, na.rm = T)
    if (!is.na(rsat.species) && (!exists("genome.info") || genome.info$species != 
        rsat.species)) {
        cat("Initializing genome info for organism", organism, 
            "\n")
        set.param("no.genome.info", FALSE)
        genome.info <- get.genome.info()
        if (is.na(taxon.id) || length(taxon.id) <= 0) {
            taxon.id <- genome.info$taxon.id
            set.param("taxon.id", taxon.id, override = T)
        }
        genome.info$operons <- NULL
        if (operon.shift && !no.genome.info) 
            genome.info$operons <- get.operon.predictions("microbes.online")
        if (exists("genome.info") && !is.null(genome.info$feature.names) && 
            (!exists("ratios") || is.null(ratios))) 
            tmp <- toupper(subset(genome.info$feature.names, 
                type == "primary", select = "names", drop = T))
        else if (!no.genome.info) 
            tmp <- toupper(subset(genome.info$feature.names, 
                type == "primary" | names %in% attr(ratios, "rnames"), 
                select = "names", drop = T))
        else if (exists("ratios") && !is.null(ratios)) 
            tmp <- toupper(attr(ratios, "rnames"))
        qqq <- sapply(1:4, function(nch) max(table(substr(tmp, 
            1, nch)))/length(tmp))
        nch <- 0
        if (any(qqq > 0.6)) {
            nch <- which(qqq > 0.6)
            nch <- nch[length(nch)]
        }
        else if (any(qqq > 0.4)) {
            nch <- which(qqq > 0.4)
            nch <- nch[length(nch)]
        }
        if (nch > 0) {
            prefix <- names(which.max(table(substr(tmp, 1, nch))))
            cat("Assuming gene names have common prefix '", prefix, 
                "'.\n", sep = "")
            genome.info$gene.prefix <- prefix
        }
        else {
            cat("Could not find a common gene identifier prefix. This only matters if there's no expression matrix.\n")
            prefix <- genome.info$gene.prefix <- NA
        }
        if (!is.na(prefix) && (!exists("ratios") || is.null(ratios))) {
            cat("WARNING: No ratios matrix -- will generate an 'empty' one with all known ORFs as probes.\n")
            rows <- unique(as.character(subset(genome.info$feature.names, 
                grepl(paste("^", prefix, sep = ""), names, ignore = T, 
                  perl = T), select = "names", drop = T)))
            ratios <- list(ratios = t(t(rep(NA, length(rows)))))
            rownames(ratios$ratios) <- rows
            attr(ratios, "rnames") <- sort(unique(rows))
            rm(rows)
            attr(ratios, "nrow") <- length(attr(ratios, "rnames"))
            attr(ratios, "ncol") <- 1
        }
        rm(nch, prefix, tmp, qqq)
        networks <- list()
        if (!is.na(net.iters) && any(net.iters %in% 1:n.iter)) {
            if (file.exists("data/STRING/string.csv")) {
                networks[["string"]] <- read.csv("data/STRING/string.csv", 
                  row.names = 1, header = TRUE)
            }
            else if (length(grep("string", names(net.weights))) > 
                0) {
                if ("string" %in% names(net.weights) || "string.combined" %in% 
                  names(net.weights)) {
                  if ("string.combined" %in% names(net.weights)) 
                    names(net.weights)[names(net.weights) == 
                      "string.combined"] <- "string"
                  string <- get.STRING.links(genome.info$org.id$V1[1], 
                    detailed = F)
                  string <- subset(string, combined_score >= 
                    500)
                  cat("Read in", nrow(string), "STRING edges that pass cutoff (500); weight =", 
                    net.weights["string"], "\n")
                  string$combined_score <- 1000 * exp(string$combined_score/1000)/exp(1)
                  networks[["string"]] <- string
                  rm(string)
                }
                if (length(grep("string.", names(net.weights))) > 
                  0) {
                  string <- get.STRING.links(genome.info$org.id$V1[1], 
                    detailed = T)
                  for (n in grep("string.", names(net.weights), 
                    val = T)) {
                    tp <- strsplit(n, ".", fixed = T)[[1]][2]
                    if (tp %in% colnames(string)) {
                      str <- string[, c("protein1", "protein2", 
                        tp)]
                      colnames(str)[3] <- "combined_score"
                      str <- subset(str, combined_score >= 500)
                      cat("Read in", nrow(str), n, "edges that pass cutoff (500); weight =", 
                        net.weights[n], "\n")
                      str$combined_score <- 1000 * exp(string$combined_score/1000)/exp(1)
                      networks[[n]] <- str
                    }
                  }
                  rm(string, tp, str)
                }
            }
            if ("operons" %in% names(net.weights) && !is.null(genome.info$operons)) {
                cat("Converting operon predictions into a network...\n")
                tmp <- tapply(genome.info$operons$gene, genome.info$operons$head)
                names(tmp) <- genome.info$operons$gene
                mc <- get.parallel(length(unique(tmp)))
                out.sif <- do.call(rbind, mc$apply(unique(tmp), 
                  function(j) {
                    whch <- which(tmp == j)
                    gs <- names(whch)
                    if (length(gs) <= 1 || length(gs) > attr(ratios, 
                      "nrow")/20) 
                      return(NULL)
                    tmp.sif <- t(combn(gs, 2))
                    tmp.sif <- tmp.sif[tmp.sif[, 1] != tmp.sif[, 
                      2], , drop = F]
                    data.frame(protein1 = tmp.sif[, 1], protein2 = tmp.sif[, 
                      2], combined_score = rep(1000, nrow(tmp.sif)))
                  }))
                out.sif$combined_score <- rep(1000, nrow(out.sif))
                colnames(out.sif) <- c("protein1", "protein2", 
                  "combined_score")
                networks[["operons"]] <- out.sif
                rm(tmp, mc, out.sif)
            }
            if (length(grep("prolinks", names(net.weights))) > 
                0) {
                prolinks.links <- get.prolinks.links(org.id = genome.info$org.id$V2[1])
                for (i in names(prolinks.links)) {
                  networks[[paste("prolinks", i, sep = ".")]] <- prolinks.links[[i]]
                  cat("Read in", nrow(prolinks.links[[i]]), i, 
                    "Prolinks edges; weight =", net.weights["prolinks"], 
                    "\n")
                }
                rm(prolinks.links, i)
            }
            if (length(grep("predictome", names(net.weights))) > 
                0) {
                cat("Reading in predictome links from http://predictome.bu.edu/data/\n")
                pred.links <- get.predictome.links(org.id = organism)
                for (i in names(pred.links)) {
                  networks[[paste("pred", i, sep = ".")]] <- pred.links[[i]]
                  cat("Read in", nrow(pred.links[[i]]), i, "Predictome edges; weight =", 
                    net.weights["prolinks"], "\n")
                }
                rm(pred.links, i)
            }
            if (exists("net.weights") && length(net.weights) > 
                0) {
                for (i in names(net.weights)) {
                  if (file.exists(i)) {
                    cat("Loading sif interactions from file:", 
                      i, "; weight =", net.weights[i], "\n")
                    sif <- load.sif.interactions(i)
                  }
                  else if (exists(i)) {
                    cat("Using network '", i, "' that exists in memory already; weight = ", 
                      net.weights[i], "\n", sep = "")
                    sif <- get(i)
                    if (ncol(sif) == 2) 
                      sif <- cbind(sif, rep(1, nrow(sif)))
                    colnames(sif) <- c("protein1", "protein2", 
                      "combined_score")
                  }
                  else {
                    next
                  }
                  networks[[basename(i)]] <- sif
                }
                rm(sif, i)
            }
            if (exists("grouping.weights") && length(grouping.weights) > 
                0) {
                if (exists("net.weights")) 
                  net.weights <- c(net.weights, grouping.weights)
                else net.weights <- grouping.weights
                for (i in names(grouping.weights)) {
                  if (file.exists(i)) {
                    cat("Loading groupings from file:", i, "; weight =", 
                      grouping.weights[i], "\n")
                    sif <- load.sif.interactions(i)
                  }
                  else {
                    cat("Using groupings from '", i, "' that exists in memory already; weight = ", 
                      grouping.weights[i], "\n", sep = "")
                    sif <- get(i)
                    if (ncol(sif) == 2) 
                      sif <- cbind(sif, combined_score = rep(1, 
                        nrow(sif)))
                  }
                  colnames(sif) <- c("group", "protein", "combined_score")
                  if (sum(unique(as.character(sif$protein)) %in% 
                    attr(ratios, "rnames")) < sum(unique(as.character(sif$group)) %in% 
                    attr(ratios, "rnames"))) {
                    sif <- sif[, c(2, 1, 3)]
                    colnames(sif) <- c("group", "protein", "combined_score")
                  }
                  sif <- sif[order(sif$group), ]
                  tmp <- tapply(sif$protein, sif$group)
                  names(tmp) <- as.character(sif$protein)
                  cat("Converting", length(unique(tmp)), "groupings to a network (this may take a while for big grouping files)...")
                  mc <- get.parallel(length(unique(tmp)))
                  out.sif <- mc$apply(unique(tmp), function(j) {
                    whch <- which(tmp == j)
                    gs <- names(whch)
                    if (length(gs) <= 1 || length(gs) > attr(ratios, 
                      "nrow")/20) 
                      return(NULL)
                    ws <- sif$combined_score[whch]
                    names(ws) <- gs
                    tmp.sif <- t(combn(gs, 2))
                    tmp.sif <- tmp.sif[tmp.sif[, 1] != tmp.sif[, 
                      2], , drop = F]
                    tmp.sif <- data.frame(protein1 = tmp.sif[, 
                      1], protein2 = tmp.sif[, 2], combined_score = (ws[tmp.sif[, 
                      1]] + ws[tmp.sif[, 2]])/2)
                    rownames(tmp.sif) <- NULL
                    if (j%%100 == 0) 
                      cat(j)
                    cat(".")
                    tmp.sif
                  })
                  cat(length(unique(tmp)), "... ")
                  out.sif <- do.call(rbind, out.sif)
                  colnames(out.sif) <- c("protein1", "protein2", 
                    "combined_score")
                  networks[[basename(i)]] <- out.sif
                  cat("DONE\n")
                }
                rm(sif, tmp, out.sif, i, mc)
            }
            if (exists("networks")) {
                for (n in names(networks)) {
                  nn <- networks[[n]]
                  if (nrow(nn) <= 0) {
                    cat("WARNING: no edges in network", n, "... skipping.\n")
                    next
                  }
                  nodes <- unique(c(as.character(nn$protein1), 
                    as.character(nn$protein2)))
                  cat(nrow(nn), "edges,", length(nodes), "nodes in network", 
                    n, "\n")
                  nn <- subset(nn, as.character(protein1) != 
                    as.character(protein2))
                  dupes <- duplicated(nn[, c("protein1", "protein2")])
                  if (sum(dupes) > 0) {
                    cat("Merging", sum(dupes), "duplicate edges in network", 
                      n, "; this could take a while for networks with lots of nodes...\n")
                    tmp.nn <- subset(nn, dupes)
                    dupe.nodes <- unique(c(as.character(tmp.nn$protein1), 
                      as.character(tmp.nn$protein2)))
                    if (length(dupe.nodes) < 6000) {
                      tmp <- tapply(tmp.nn$combined_score, tmp.nn[, 
                        c("protein1", "protein2")], sum, na.rm = T)
                      tmp2 <- which(!is.na(tmp), arr = T)
                      nn.new <- data.frame(protein1 = rownames(tmp)[tmp2[, 
                        1]], protein2 = colnames(tmp)[tmp2[, 
                        2]], combined_score = tmp[tmp2])
                      rm(tmp, tmp2)
                      nn <- rbind(nn.new, nn)
                      rm(nn.new)
                      nn <- nn[!duplicated(nn[, c("protein1", 
                        "protein2")]), ]
                    }
                    rm(tmp.nn, dupe.nodes, dupes)
                  }
                  if (exists("ratios") && !is.null(ratios) && 
                    !any(nodes %in% attr(ratios, "rnames"))) {
                    if (median(nchar(nodes)) > median(nchar(attr(ratios, 
                      "rnames"))) && any(substr(nodes, 1, median(nchar(attr(ratios, 
                      "rnames")))) %in% attr(ratios, "rnames"))) {
                      nn$protein1 <- substr(as.character(nn$protein1), 
                        1, median(nchar(attr(ratios, "rnames"))))
                      nn$protein2 <- substr(as.character(nn$protein2), 
                        1, median(nchar(attr(ratios, "rnames"))))
                      nodes <- unique(c(as.character(nn$protein1), 
                        as.character(nn$protein2)))
                    }
                    if (!is.null(genome.info$synonyms)) {
                      rr <- attr(ratios, "rnames")[!attr(ratios, 
                        "rnames") %in% nodes]
                      if (length(rr) > 0) {
                        cat("Reconciling network", n, length(rr), 
                          "node names with probe names...\n")
                        syns <- get.synonyms(rr)
                        mc <- get.parallel(length(syns))
                        is.there <- unlist(mc$apply(syns, function(i) any(i %in% 
                          nodes)))
                        syns <- syns[is.there]
                        nnc1 <- as.character(nn$protein1)
                        nnc2 <- as.character(nn$protein2)
                        nnc1.t <- !nnc1 %in% attr(ratios, "rnames")
                        nnc2.t <- !nnc2 %in% attr(ratios, "rnames")
                        mc <- get.parallel(2)
                        tmp <- mc$apply(1:2, function(ii) {
                          for (i in names(syns)) {
                            if (ii == 1) 
                              nnc1[nnc1.t & nnc1 %in% syns[[i]]] <- i
                            else nnc2[nnc2.t & nnc2 %in% syns[[i]]] <- i
                          }
                          if (ii == 1) 
                            return(nnc1)
                          else return(nnc2)
                        })
                        nnc1 <- tmp[[1]]
                        nnc2 <- tmp[[2]]
                        rm(tmp, nnc1.t, nnc2.t)
                        cat(sum(!is.there), "probes have no nodes in", 
                          n, "network (but", sum(attr(ratios, 
                            "rnames") %in% nodes, na.rm = T) + 
                            sum(is.there), "do)\n")
                        nn$protein1 <- nnc1
                        nn$protein2 <- nnc2
                        tmp <- nnc1 %in% attr(ratios, "rnames") & 
                          nnc2 %in% attr(ratios, "rnames")
                        nn <- subset(nn, tmp == TRUE)
                        rm(tmp, syns, is.there, nnc1, nnc2, nnc1.t, 
                          nnc2.t, tmp, rr, i)
                      }
                    }
                  }
                  else {
                    cat(sum(!attr(ratios, "rnames") %in% nodes), 
                      "probes have no nodes in", n, "network (but", 
                      sum(attr(ratios, "rnames") %in% nodes, 
                        na.rm = T), "do)\n")
                  }
                  ttmp <- nn[, c(2, 1, 3)]
                  colnames(ttmp) <- colnames(nn)
                  nn <- rbind(nn, ttmp)
                  rm(ttmp)
                  nn <- nn[!duplicated(nn[, c("protein1", "protein2")]), 
                    ]
                  cat(n, "network filtered, symmetrized and uniquified:", 
                    nrow(nn), "edges.\n")
                  networks[[n]] <- nn
                }
                rm(n, nn, nodes, dupes)
                if (length(networks) > 1) {
                  sums <- sapply(networks, function(n) sum(n$combined_score, 
                    na.rm = T))
                  ms <- min(sums[sums > 0], na.rm = T)
                  if (length(sums) > 0 && !is.na(ms)) 
                    for (n in names(networks)) networks[[n]]$combined_score <- networks[[n]]$combined_score/sums[n] * 
                      ms
                  rm(n, sums, ms)
                }
            }
            names(net.weights) <- basename(names(net.weights))
        }
        if (!is.null(genome.info$genome.seqs)) {
            genome.info$all.upstream.seqs <- genome.info$bg.list <- list()
            for (i in names(mot.weights)) {
                cat("Pre-computing all", i, "seqs for background distribution (", 
                  motif.upstream.scan[[i]], ")...\n")
                genome.info$all.upstream.seqs[[i]] <- get.sequences(attr(ratios, 
                  "rnames"), seq.type = i, distance = motif.upstream.scan[[i]])
                cat(sum(!attr(ratios, "rnames") %in% names(genome.info$all.upstream.seqs[[i]])), 
                  "probes have no", i, "sequence.\n")
                if (!is.na(bg.order[i])) {
                  cat("Pre-computing", i, "residue bg distrib (order=", 
                    bg.order[i], ")...\n")
                  tmp.seqs <- if (!is.null(genome.info$all.upstream.seqs[[i]])) 
                    genome.info$all.upstream.seqs[[i]]
                  else get.sequences(attr(ratios, "rnames"), 
                    distance = motif.upstream.search[[i]], seq.type = i)
                  capture.output(genome.info$bg.list[[i]] <- mkBgFile(tmp.seqs, 
                    order = bg.order[i], use.rev.comp = grepl("-revcomp", 
                      meme.addl.args[i])))
                  rm(tmp.seqs)
                }
                else {
                  cat("NOT USING a global sequence background distribution!\n")
                }
            }
        }
        if (!no.genome.info) {
            cat("Loading COG functional codes (for plotting), org. code", 
                cog.org, ": trying NCBI whog file...\n")
            genome.info$cog.code <- get.COG.code(cog.org)
        }
        cat(sum(!is.na(genome.info$cog.code)), "genes have a COG code (", 
            sum(is.na(genome.info$cog.code)), "do not)\n")
    }
    if ((!exists("row.membership") || nrow(row.membership) != 
        attr(ratios, "nrow") || nrow(col.membership) != attr(ratios, 
        "ncol")) && exists("ratios")) {
        if (!is.null(ratios) && attr(ratios, "ncol") > 1) {
            cat("Seeding clusters using methods:", seed.method, 
                "\n")
            tmp <- seed.clusters(k.clust, seed.method = seed.method["rows"], 
                col.method = seed.method["cols"])
        }
        else {
            cat("Seeding clusters using methods: rnd rnd\n")
            tmp <- seed.clusters(k.clust, seed.method = "rnd", 
                col.method = "rnd")
        }
        row.membership <- tmp$row.membership
        col.membership <- tmp$col.membership
        rm(tmp)
    }
    iter <- 1
    meme.scores <- clusterStack <- history <- list()
    for (i in names(mot.weights)) {
        meme.scores[[i]] <- list()
        meme.scores[[i]][[k.clust + 1]] <- ""
    }
    stats <- row.scores <- col.scores <- mot.scores <- net.scores <- r.scores <- NULL
    old.row.membership <- old.col.membership <- r.scores <- NULL
    if (!exists("favorite.cluster")) 
        favorite.cluster <- function() min(which(tabulate(row.membership) > 
            cluster.rows.allowed[1] * 2))
    resid.scaling <- extend.vec(resid.scaling)
    mot.scaling <- extend.vec(mot.scaling)
    net.scaling <- extend.vec(net.scaling)
    n.motifs <- lapply(n.motifs, extend.vec)
    min.motif.width <- lapply(motif.width.range, function(i) extend.vec(i[1]))
    max.motif.width <- lapply(motif.width.range, function(i) extend.vec(i[2]))
    n.clust.per.row <- extend.vec(n.clust.per.row)
    n.clust.per.col <- extend.vec(n.clust.per.col)
    fuzzy.index <- extend.vec(fuzzy.index)
    is.inited <- TRUE
    if (is.null(env)) 
        env <- new.env(hash = T)
    attr(env, "class") <- c("environment", "cmonkey")
    for (i in ls()) {
        if (i %in% c("i", "env")) 
            next
        tmp <- get(i)
        if (class(tmp) == "function") 
            environment(tmp) <- env
        assign(i, tmp, envir = env)
    }
    if (exists("func.each.iter")) {
        env$func.each.iter <- func.each.iter
        environment(env$func.each.iter) <- env
    }
    if (exists("favorite.cluster")) {
        env$favorite.cluster <- favorite.cluster
        environment(env$favorite.cluster) <- env
    }
    cat("INITIALIZATION IS COMPLETE.\n")
    env
}
cmonkey.one.iter <-
function (env) 
{
    env$row.memb <- t(apply(row.membership, 1, function(i) 1:k.clust %in% 
        i))
    env$col.memb <- t(apply(col.membership, 1, function(i) 1:k.clust %in% 
        i))
    tmp <- get.all.scores()
    env$row.scores <- tmp$r[, ]
    env$mot.scores <- tmp$m
    env$net.scores <- tmp$n
    env$col.scores <- tmp$c
    env$meme.scores <- tmp$ms
    if (!is.null(tmp$cns)) 
        env$cluster.net.scores <- tmp$cns
    tmp <- get.combined.scores()
    env$r.scores <- tmp$r
    env$c.scores <- tmp$c
    if (length(tmp$scalings) > 0) {
        env$resid.scaling[iter] <- tmp$scalings["row"]
        env$mot.scaling[iter] <- tmp$scalings["mot"]
        env$net.scaling[iter] <- tmp$scalings["net"]
    }
    if (fuzzy.index[iter] > 1e-05) {
        env$r.scores[, ] <- env$r.scores[, ] + rnorm(length(r.scores), 
            sd = sd(r.scores[row.memb], na.rm = T) * fuzzy.index[iter])
        env$c.scores[, ] <- env$c.scores[, ] + rnorm(length(c.scores), 
            sd = sd(c.scores[col.memb], na.rm = T) * fuzzy.index[iter])
    }
    tmp <- get.density.scores(ks = 1:k.clust)
    env$rr.scores <- tmp$r
    env$cc.scores <- tmp$c
    if (iter %in% stats.iters) {
        env$clusterStack <- get.clusterStack(ks = 1:k.clust)
        st <- get.stats()
        env$stats <- rbind(stats, st)
        cat(organism, as.matrix(stats[nrow(stats), ]), "\n")
    }
    else {
        cat(sprintf("==> %04d %.3f %.3f %.3f\n", iter, mean(row.scores[row.memb], 
            na.rm = T), if (!is.null(mot.scores)) 
            mean(mot.scores[, ][row.memb & mot.scores[, ] < 0], 
                na.rm = T, trim = 0.05)
        else NA, if (!is.null(net.scores)) 
            mean(net.scores[, ][row.memb], na.rm = T, trim = 0.05)
        else NA))
    }
    size.compensation.func.rows <- function(n) exp(-n/(attr(ratios, 
        "nrow") * n.clust.per.row[iter]/k.clust))
    size.compensation.func.cols <- function(n) exp(-n/(attr(ratios, 
        "ncol") * n.clust.per.col[iter]/k.clust))
    for (k in 1:k.clust) {
        if (sum(row.memb[, k]) > 0) 
            env$rr.scores[, k] <- env$rr.scores[, k] * size.compensation.func.rows(sum(row.memb[, 
                k]))
        else env$rr.scores[, k] <- env$rr.scores[, k] * size.compensation.func.rows(cluster.rows.allowed[1])
        if (sum(col.memb[, k]) > 0) 
            env$cc.scores[, k] <- env$cc.scores[, k] * size.compensation.func.cols(sum(col.memb[, 
                k]))
        else env$cc.scores[, k] <- env$cc.scores[, k] * size.compensation.func.cols(attr(ratios, 
            "ncol")/10)
    }
    if (exists("row.membership")) {
        env$old.row.membership <- row.membership
        env$old.col.membership <- col.membership
    }
    tmp <- get.updated.memberships()
    env$row.membership <- tmp$r
    env$col.membership <- tmp$c
    if (TRUE && iter%%10 == sample(0:9, 1)) {
        if (merge.cutoffs["n"] > 0 && merge.cutoffs["cor"] < 
            1) {
            tmp.m <- merge.cutoffs["n"]
            if (tmp.m < 1 && runif(1) <= tmp.m) 
                tmp.m <- 1
            if (tmp.m >= 1) {
                tmp <- consolidate.duplicate.clusters(scores = r.scores, 
                  cor.cutoff = merge.cutoffs["cor"], n.cutoff = tmp.m, 
                  motif = F)
                env$row.membership <- tmp$r
                env$meme.scores <- tmp$ms
            }
        }
        tmp <- re.seed.empty.clusters(toosmall.r = cluster.rows.allowed[1], 
            toosmall.c = attr(ratios, "ncol")/10, n.r = cluster.rows.allowed[1] * 
                2, n.c = attr(ratios, "ncol")/5)
        env$row.membership <- tmp$r
        env$col.membership <- tmp$c
        meme.scores <- tmp$ms
    }
    if (!is.na(plot.iters) && iter %in% plot.iters) {
        env$clusterStack <- get.clusterStack(ks = 1:k.clust)
        try(plot.stats(iter, plot.clust = env$favorite.cluster()))
    }
    if (exists("func.each.iter")) 
        try(func.each.iter())
    if (any(script.every.iter != "")) {
        for (f in script.every.iter) {
            if (file.exists(f) && file.info(f)$size > 1) {
                tmp <- readLines(f)
                if (all(substr(tmp, 1, 1) == "#")) 
                  next
                if (tmp[1] != "## QUIET") 
                  cat("Sourcing the script '", f, "' ...\n", 
                    sep = "")
                try(source(f, echo = tmp[1] != "## QUIET", local = T))
            }
        }
    }
    if (big.matrices > 0 && require(ff)) {
        dir.create(cmonkey.filename, recursive = T, show = F)
        for (i in c("row.scores", "mot.scores", "net.scores", 
            "r.scores", "rr.scores", "col.scores", "c.scores", 
            "cc.scores", "net.scores", "row.memb", "col.memb")) if (!is.null(env[[i]]) && 
            !is.ff(env[[i]]) && object.size(env[[i]]) >= big.matrices) 
            env[[i]] <- as.ff(env[[i]], filename = paste(cmonkey.filename, 
                i, sep = "/"), overwrite = T)
        for (i in names(env$meme.scores)) {
            all.pv <- env$meme.scores[[i]]$all.pv
            if (!is.null(all.pv) && !is.ff(all.pv) && object.size(all.pv) >= 
                big.matrices) 
                env$meme.scores[[i]]$all.pv <- as.ff(all.pv, 
                  filename = paste(cmonkey.filename, "/all.pv.", 
                    i, sep = ""), overwrite = T)
        }
    }
    if (get.parallel()$par) {
        chld <- children()
        if (length(chld) > 0) {
            try({
                kill(chld)
                tmp <- collect(chld)
            })
        }
    }
    NULL
}
col.let <-
c("A", "C", "G", "T")
compare.clusters <-
function (k1, k2, scores = r.scores) 
{
    plot(scores[, k1], scores[, k2], pch = 20, cex = 0.5)
    points(scores[get.rows(k1), k1], scores[get.rows(k1), k2], 
        col = "red", cex = 0.5, pch = 20)
    points(scores[get.rows(k2), k1], scores[get.rows(k2), k2], 
        col = "green", cex = 0.5, pch = 20)
    points(scores[get.rows(k1)[get.rows(k1) %in% get.rows(k2)], 
        k1], scores[get.rows(k2)[get.rows(k2) %in% get.rows(k1)], 
        k2], col = "blue", cex = 0.5, pch = 20)
    cat(length(get.rows(k1)), length(get.rows(k2)), sum(get.rows(k1) %in% 
        get.rows(k2)), "\t", cor(scores[, k1], scores[, k2], 
        use = "pairwise", method = "pearson"), "\n")
}
consolidate.duplicate.clusters <-
function (scores = r.scores, cor.cutoff = 0.9, n.cutoff = 5, 
    motif = F, seq.type = "upstream") 
{
    row.m <- row.membership
    ms <- meme.scores
    cors <- id.duplicate.clusters(scores, cor.cutoff)
    if (nrow(cors) <= 0) 
        return(invisible(list(r = row.m, ms = meme.scores, scores = scores)))
    cr <- max(cors[, 3], na.rm = T)
    n.cut <- 1
    while (cr > cor.cutoff && n.cut <= n.cutoff) {
        tmp <- cors[which(cors[, 3] == cr), 1:2]
        if (any(get.rows(tmp[1]) %in% get.rows(tmp[2]))) {
            ev1 <- if (is.null(meme.scores[[seq.type]][[tmp[1]]]$meme.out)) 
                Inf
            else min(sapply(meme.scores[[seq.type]][[tmp[1]]]$meme.out, 
                "[[", "e.value"), na.rm = T)
            ev2 <- if (is.null(meme.scores[[seq.type]][[tmp[2]]]$meme.out)) 
                Inf
            else min(sapply(meme.scores[[seq.type]][[tmp[2]]]$meme.out, 
                "[[", "e.value"), na.rm = T)
            if (!(is.infinite(ev1) && is.infinite(ev2)) && ev2 < 
                ev1) 
                tmp <- tmp[c(2, 1)]
            else if (length(get.rows(tmp[1])) < length(get.rows(tmp[2]))) 
                tmp <- tmp[c(2, 1)]
            row.m[row.m == tmp[2]] <- tmp[1]
            cat("MERGING:", tmp, "\t", length(get.rows(tmp[1])), 
                length(get.rows(tmp[2])), "\t", length(unique(c(get.rows(tmp[1]), 
                  get.rows(tmp[2])))), "\t", cr, "\n")
            scores[, tmp[2]] <- NA
            for (tt in names(mot.weights)) {
                ms[[tt]][[tmp[2]]] <- list(iter = iter)
                if (motif && sum(!get.rows(tmp[1]) %in% get.rows(tmp[2])) > 
                  0) 
                  ms[[tt]][[tmp[1]]] <- try(meme.one.cluster(tmp[1], 
                    verbose = T, consens = meme.consensus, seq.type = tt))
            }
            n.cut <- n.cut + 1
        }
        cors[which(cors[, 3] == cr), ] <- NA
        cr <- max(cors[, 3], na.rm = T)
    }
    invisible(list(r = row.m, ms = ms, scores = scores))
}
dlf <-
function (f, url, msg = NULL) 
{
    err <- 0
    if (!file.exists(f) || file.info(f)$size == 0) {
        if (!file.exists(dirname(f))) 
            try(dir.create(dirname(f), recursive = T))
        if (!is.null(msg)) 
            cat(msg, "\n")
        err <- try(download.file(url, destfile = f, mode = "wb"))
    }
    err
}
extend.vec <-
function (v, n = n.iter) 
{
    if (length(v) < n) 
        v <- c(v, rep(v[length(v)], n.iter - length(v)))
    v
}
get.COG.code <-
function (org, rows = attr(ratios, "rnames")) 
{
    up.rows <- toupper(rows)
    out <- rep("-", length(rows))
    names(out) <- up.rows
    fname <- "data/COG_whog.txt"
    err <- dlf(fname, "ftp://ftp.ncbi.nih.gov/pub/COG/COG/whog", 
        "Fetching COG codes from NCBI...")
    lines <- readLines(gzfile(fname))
    hits <- grep(paste(org, "\\:|COG", sep = ""), lines)
    hpy.hits <- grep(paste(org, "\\:", sep = ""), lines[hits])
    if (length(hpy.hits) <= 0) 
        return(NULL)
    genes <- gsub(paste("\\s+", org, "\\:\\s+", sep = ""), "", 
        lines[hits][hpy.hits], perl = T)
    cogs <- lines[hits][hpy.hits - 1]
    cog.codes <- sapply(strsplit(cogs, "[\\s+\\[\\]]", perl = T), 
        "[", 2)
    cog.codes <- substr(cog.codes, 1, 1)
    genes <- toupper(genes)
    mc <- get.parallel(attr(ratios, "nrow"))
    tmp <- mc$apply(1:length(genes), function(i) {
        gn <- strsplit(genes[i], " ")[[1]]
        if (length(gn) <= 0) 
            next
        gn <- gn[!is.na(gn)]
        if (!all(gn %in% up.rows)) 
            gn <- toupper(unlist(get.synonyms(gn, ignore = T)))
        if (sum(gn %in% up.rows) <= 0) 
            return(character())
        gn <- gn[gn %in% up.rows]
        out[up.rows %in% gn] <- cog.codes[i]
        out
    })
    for (t in tmp) if (length(t) > 0) 
        out[t != "-"] <- t[t != "-"]
    out[out == "-"] <- NA
    names(out) <- rows
    out
}
get.STRING.links <-
function (org.id = genome.info$org.id$V1[1], detailed = T) 
{
    fname <- paste("data/STRING/protein.links.detailed.", string.version, 
        ".txt.gz", sep = "")
    if (!file.exists(fname) || !detailed) 
        fname <- paste("data/STRING/protein.links.", string.version, 
            ".txt.gz", sep = "")
    small.fname <- paste("data/", rsat.species, "/string_links_", 
        detailed, "_", org.id, ".tab", sep = "")
    if ((!file.exists(small.fname) || file.info(small.fname)$size <= 
        0)) {
        if (!file.exists(fname)) {
            url <- paste("http://string.embl.de/newstring_download/protein.links.", 
                string.version, ".txt.gz", sep = "")
            err <- dlf(fname, url, paste("Fetching STRING protein links file", 
                url, "\nThis will take a while...\n"))
            if (class(err) == "try-error") {
                url <- paste("http://pinnacle/~dreiss/cMonkey/protein.links.", 
                  string.version, ".txt.gz", sep = "")
                err <- dlf(fname, url, paste("Fetching STRING protein links file", 
                  url, "\nThis will take a while...\n"))
            }
            if (class(err) == "try-error" || !file.exists(fname)) 
                stop("Whoops, could not download the file. Please try to get it yourself and put it in data/STRING/ .\n")
        }
        cat("Loading organism-specific EMBL STRING interaction links (requires UNIX programs \"gunzip\" and \"grep\")", 
            "...\nUsing local file", fname, "->", small.fname, 
            "\n")
        system(paste("gunzip -c ", fname, " | grep -E 'combined_score|^", 
            org.id, ".' > ", small.fname, sep = ""))
    }
    if (file.exists(small.fname) && file.info(small.fname)$size == 
        0) 
        system(paste("gunzip -c ", fname, " | grep -E 'combined_score|^", 
            org.id, ".' > ", small.fname, sep = ""))
    if (file.exists(small.fname) && file.info(small.fname)$size > 
        0) {
        cat("Loading EMBL STRING interaction links from local file", 
            small.fname, "\n")
        string.links <- read.delim(gzfile(small.fname), sep = " ", 
            head = T)
        string.links$protein1 <- gsub(paste(org.id, ".", sep = ""), 
            "", string.links$protein1)
        string.links$protein2 <- gsub(paste(org.id, ".", sep = ""), 
            "", string.links$protein2)
    }
    dlf(paste("data/STRING/species.", string.version, ".txt", 
        sep = ""), paste("http://string.embl.de/newstring_download/species.", 
        string.version, ".txt", sep = ""))
    invisible(string.links)
}
get.all.scores <-
function (ks = 1:k.clust, force.resid = F, force.motif = F, force.net = F) 
{
    mc <- get.parallel(length(ks))
    if (force.resid || (resid.scaling[iter] > 0 && !is.na(resid.iters[1]) && 
        iter %in% resid.iters)) {
        if (is.null(row.scores)) {
            row.scores <- matrix(0, nrow = attr(ratios, "nrow"), 
                ncol = max(ks))
            rownames(row.scores) <- attr(ratios, "rnames")
        }
        else row.scores[, ] <- 0
        for (i in names(ratios)) {
            if (resid.weights[i] == 0 || is.na(resid.weights[i])) 
                next
            tmp.row <- do.call(cbind, mc$apply(ks, get.row.scores, 
                ratios = ratios[[i]]))
            tmp.rm <- row.memb[rownames(row.memb) %in% rownames(tmp.row), 
                ]
            tmp <- is.infinite(tmp.row) | is.na(tmp.row)
            if (any(tmp)) 
                tmp.row[tmp] <- quantile(tmp.row[tmp.rm & !tmp], 
                  0.95)
            tmp <- rownames(row.scores) %in% rownames(ratios[[i]])
            row.scores[tmp, ks] <- row.scores[tmp, ks] + tmp.row[, 
                ] * resid.weights[i]
        }
        rm(tmp.row, tmp.rm, tmp)
    }
    if (is.null(col.scores)) {
        col.scores <- matrix(0, nrow = attr(ratios, "ncol"), 
            ncol = max(ks))
        rownames(col.scores) <- attr(ratios, "cnames")
    }
    else col.scores[, ] <- 0
    for (i in names(resid.weights)) {
        if (resid.weights[i] == 0 || is.na(resid.weights[i])) 
            next
        tmp.col <- do.call(cbind, mc$apply(ks, get.col.scores, 
            ratios = ratios[[i]]))
        tmp.cm <- col.memb[rownames(col.memb) %in% rownames(tmp.col), 
            ]
        tmp <- is.infinite(tmp.col) | is.na(tmp.col)
        if (any(tmp)) 
            tmp.col[tmp] <- quantile(tmp.col[tmp.cm & !tmp], 
                0.95)
        tmp <- rownames(col.scores) %in% colnames(ratios[[i]])
        col.scores[tmp, ks] <- col.scores[tmp, ks] + tmp.col[, 
            ] * resid.weights[i]
    }
    rm(tmp.col, tmp.cm, tmp)
    if (force.motif || (mot.scaling[iter] > 0 && !is.na(meme.iters[1]) && 
        iter %in% meme.iters && exists("genome.info"))) {
        for (i in names(mot.weights)) {
            if (mot.weights[i] == 0 || is.na(mot.weights[i])) 
                next
            meme.scores[[i]] <- meme.all.clusters(ks, verbose = T, 
                seq.type = i)
        }
    }
    if (force.motif || (mot.scaling[iter] > 0 && !is.na(mot.iters[1]) && 
        iter %in% c(meme.iters, mot.iters) && exists("genome.info"))) {
        if (is.null(mot.scores)) {
            mot.scores <- matrix(0, nrow = attr(ratios, "nrow"), 
                ncol = max(ks))
            rownames(mot.scores) <- attr(ratios, "rnames")
        }
        else mot.scores[, ] <- 0
        for (i in names(mot.weights)) {
            if (mot.weights[i] == 0 || is.na(mot.weights[i])) 
                next
            tmp.mot <- do.call(cbind, mc$apply(ks, get.motif.scores, 
                seq.type = i))
            tmp.mot[is.infinite(tmp.mot) | is.na(tmp.mot)] <- 0
            mot.scores[, ] <- mot.scores[, ] + tmp.mot[, ] * 
                mot.weights[i]
        }
        rm(tmp.mot)
    }
    cluster.ns <- NULL
    if (force.net || (net.scaling[iter] > 0 && !is.na(net.iters[1]) && 
        exists("genome.info") && iter %in% net.iters)) {
        if (is.null(net.scores)) {
            net.scores <- matrix(0, nrow = attr(ratios, "nrow"), 
                ncol = max(ks))
            rownames(net.scores) <- attr(ratios, "rnames")
        }
        else net.scores[, ] <- 0
        for (i in names(networks)) {
            if (net.weights[i] == 0 || is.na(net.weights[i])) 
                next
            tmp.net <- do.call(cbind, mc$apply(ks, get.network.scores, 
                net = networks[[i]]))
            tmp.net <- tmp.net - max(tmp.net[!is.infinite(tmp.net)], 
                na.rm = T) - abs(diff(range(tmp.net[!is.infinite(tmp.net)], 
                na.rm = T)))/10
            tmp.net[is.infinite(tmp.net) | is.na(tmp.net)] <- 0
            net.scores[, ] <- net.scores[, ] + tmp.net[, ] * 
                net.weights[i]
            cluster.ns <- cbind(cluster.ns, do.call(c, mc$apply(ks, 
                function(k) mean(tmp.net[get.rows(k), k]))))
            rm(tmp.net)
        }
        colnames(cluster.ns) <- names(networks)
        rownames(net.scores) <- attr(ratios, "rnames")
    }
    list(r = row.scores, m = mot.scores, ms = meme.scores, n = net.scores, 
        c = col.scores, cns = cluster.ns)
}
get.clust <-
function (k, fill = T, fill.motif = T, seq.type = names(mot.weights)) 
{
    gen.clust <- function(rowNames, colNames = NA, fill = F, 
        motif = F, n.motifs = 3) {
        rowNames <- rowNames[rowNames %in% attr(ratios, "rnames")]
        if (!is.null(colNames) && length(colNames) > 1 && !is.na(colNames)) 
            colNames <- colNames[colNames %in% attr(ratios, "cnames")]
        c.tmp <- list(nrows = length(rowNames), ncols = length(colNames), 
            rows = rowNames, cols = colNames, k = 999, p.clust = 1, 
            e.val = rep(999, n.motifs), resid = {
                out = rep(NA, length(resid.weights))
                names(out) <- names(resid.weights)
                resid = out
            })
        if (fill && c.tmp$nrows > 0 && c.tmp$ncols > 0 && !all(is.na(colNames))) 
            c.tmp$resid <- cluster.resid(k, names(resid.weights), 
                varNorm = TRUE)
        return(c.tmp)
    }
    cols <- get.cols(k)
    rows <- get.rows(k)
    if (length(cols) <= 0) 
        cols <- NA
    clust <- gen.clust(rows, cols, fill = fill, motif = F, n.motifs = max(unlist(n.motifs)))
    clust$k <- k
    if (fill.motif) {
        tmp <- cluster.pclust(k, seq.type)
        clust$e.val <- tmp$e.vals
        clust$p.clust <- tmp$p.clusts
    }
    clust
}
get.cluster.matrix <-
function (rows = NULL, cols = NULL, matrices = names(ratios)) 
{
    if (is.null(rows)) 
        rows <- attr(ratios, "rnames")
    if (is.null(cols)) 
        cols <- attr(ratios, "cnames")
    cols.b <- attr(ratios, "cnames")[attr(ratios, "cnames") %in% 
        cols]
    rats <- matrix(NA, nrow = length(rows), ncol = length(cols.b))
    rownames(rats) <- rows
    colnames(rats) <- cols.b
    cnames <- character()
    for (n in matrices) {
        r.tmp <- ratios[[n]][rows[rows %in% rownames(ratios[[n]])], 
            cols.b[cols.b %in% colnames(ratios[[n]])], drop = F]
        if (is.null(r.tmp) || all(is.na(r.tmp))) 
            next
        if (is.vector(r.tmp)) {
            r.tmp <- t(r.tmp)
            rownames(r.tmp) <- rows
        }
        cnames <- c(cnames, colnames(r.tmp))
        rats[rownames(r.tmp), colnames(r.tmp)] <- r.tmp
        rm(r.tmp)
    }
    rats[, colnames(rats) %in% cnames]
}
get.clusterStack <-
function (ks = 1:k.clust, force = F, ...) 
{
    if (!force && !is.null(attr(clusterStack, "iter")) && attr(clusterStack, 
        "iter") == iter) 
        return(clusterStack)
    mc <- get.parallel(length(ks))
    clusterStack <- mc$apply(ks, get.clust, ...)
    attr(clusterStack, "iter") <- iter
    clusterStack
}
get.col.scores <-
function (k, for.cols = "all", ratios = ratios[[1]]) 
{
    if (length(k) <= 0) 
        return(NULL)
    if (is.numeric(k[1])) 
        rows <- get.rows(k)
    else rows <- k
    if (for.cols[1] == "all") 
        for.cols <- colnames(ratios)
    rows <- rows[rows %in% rownames(ratios)]
    if (length(rows) <= 1) 
        return(rep(NA, length(for.cols)))
    rats <- ratios[rows, for.cols, drop = F]
    rats.mn <- matrix(colMeans(rats, na.rm = T), nrow = nrow(rats), 
        ncol = ncol(rats), byrow = T)
    rats <- rats - rats.mn
    all.colVars <- attr(ratios, "all.colVars")
    if (!is.null(all.colVars)) 
        var.norm <- all.colVars[for.cols]
    else var.norm <- rats.mn[, 1]
    rats <- colMeans(abs(rats), na.rm = T)/(var.norm + 0.01)
    return(log(rats + 1e-99))
}
get.cols <-
function (k, cm = get("col.membership")) 
unique(rownames(which(cm == k, arr = T)))
get.combined.scores <-
function () 
{
    r.scores <- row.scores[, ]
    tmp <- r.scores < -20
    r.scores[tmp] <- min(r.scores[!tmp], na.rm = T)
    rsm <- r.scores[row.memb]
    tmp <- mad(rsm, na.rm = T)
    if (tmp != 0) 
        r.scores[, ] <- (r.scores[, ] - median(rsm, na.rm = T))/tmp
    else {
        tmp <- sd(rsm, na.rm = T)
        if (tmp != 0) 
            r.scores[, ] <- (r.scores[, ] - median(rsm, na.rm = T))/tmp
    }
    rm(tmp, rsm)
    r.scores[is.infinite(r.scores)] <- NA
    r.scores[is.na(r.scores)] <- max(r.scores, na.rm = T)
    if (!is.null(mot.scores) || !is.null(net.scores)) 
        rs.quant <- quantile(r.scores, 0.01, na.rm = T)
    m.scores <- mot.scores[, ]
    if (!is.null(m.scores)) {
        tmp <- m.scores < -20
        m.scores[tmp] <- min(m.scores[!tmp], na.rm = T)
        m.scores[, ] <- m.scores[, ] - quantile(m.scores, 0.99, 
            na.rm = T)
        m.scores[, ] <- m.scores[, ]/abs(quantile(m.scores, 0.01, 
            na.rm = T)) * abs(rs.quant)
    }
    n.scores <- net.scores[, ]
    if (!is.null(n.scores)) {
        n.scores[, ] <- n.scores[, ] - quantile(n.scores, 0.99, 
            na.rm = T)
        n.scores[, ] <- n.scores[, ]/abs(quantile(n.scores, 0.01, 
            na.rm = T)) * abs(rs.quant)
    }
    c.scores <- col.scores[, ]
    tmp <- c.scores < -20
    c.scores[tmp] <- min(c.scores[!tmp], na.rm = T)
    new.weights <- c(row = resid.scaling[iter], mot = mot.scaling[iter], 
        net = net.scaling[iter])
    if (pareto.adjust.scalings && iter > 11) {
        new.weights <- pareto.adjust.weights(iter)
        if (TRUE) {
            if (new.weights["mot"] < mot.scaling[iter]/resid.scaling[iter]) 
                new.weights["mot"] <- mot.scaling[iter]/resid.scaling[iter]
            else if (new.weights["mot"] > new.weights["row"]) 
                new.weights["mot"] <- new.weights["row"]
            if (new.weights["net"] < net.scaling[iter]/resid.scaling[iter]) 
                new.weights["net"] <- net.scaling[iter]/resid.scaling[iter]
            else if (new.weights["net"] > new.weights["row"]) 
                new.weights["net"] <- new.weights["row"]
        }
        if (iter %in% stats.iters) 
            cat("New weights:", new.weights, "\n")
    }
    if (new.weights["row"] != 1) 
        r.scores[, ] <- r.scores[, ] * new.weights["row"]
    if (!is.null(m.scores)) {
        tmp <- !is.na(m.scores)
        r.scores[tmp] <- r.scores[tmp] + m.scores[tmp] * new.weights["mot"]
    }
    if (!is.null(n.scores)) {
        tmp <- !is.na(n.scores)
        r.scores[tmp] <- r.scores[tmp] + n.scores[tmp] * new.weights["net"]
    }
    invisible(list(r = r.scores, c = c.scores, scalings = new.weights))
}
get.density.scores <-
function (ks = 1:k.clust, plot = F, n.cutoff = 5) 
{
    rr <- attr(ratios, "rnames")
    bw.r <- diff(range(r.scores[, ], na.rm = T))/100
    get.rr.scores <- function(k) {
        rows <- get.rows(k)
        cols <- get.cols(k)
        rsk <- r.scores[, k]
        if (length(rows) > 0 && length(cols) > 0) {
            d <- density(rsk[rows], na.rm = T, bw = bw.r, adjust = 2, 
                from = min(rsk, na.rm = T) - 1, to = max(rsk, 
                  na.rm = T) + 1, n = 256)
            p <- approx(d$x, rev(cumsum(rev(d$y))), rsk)$y
            if (plot) {
                h = hist(rsk, breaks = 50, main = NULL, xlab = "Combined scores")
                tmp.scale <- round(attr(ratios, "nrow")/length(rows)/4)
                hist(rep(rsk[rows], tmp.scale), breaks = h$breaks, 
                  col = "red", border = "red", add = T)
                hist(rsk, breaks = h$breaks, add = T)
                lines(d$x, d$y/max(d$y, na.rm = T) * nrow(ratios)/50, 
                  col = "blue")
                lines(sort(rsk), p[order(rsk)]/max(p, na.rm = T) * 
                  nrow(ratios)/50, col = "green")
            }
        }
        else {
            p <- rep(1, attr(ratios, "nrow"))
        }
        return(p/sum(p, na.rm = T))
    }
    mc <- get.parallel(length(ks))
    rr.scores <- do.call(cbind, mc$apply(ks, get.rr.scores))
    rr.scores[is.infinite(rr.scores)] <- NA
    rownames(rr.scores) <- attr(ratios, "rnames")
    bw.c <- diff(range(col.scores[, ], na.rm = T))
    get.cc.scores <- function(k) {
        cols <- get.cols(k)
        rows <- get.rows(k)
        csk <- c.scores[, k]
        if (length(cols) > 0 && length(rows) > 0 && !all(is.na(csk[cols])) && 
            !all(is.infinite(csk[cols])) & !all(csk[cols][!is.na(csk[cols])] == 
            csk[cols[!is.na(csk[cols])][1]])) {
            d <- density(csk[cols], na.rm = T, from = min(csk, 
                na.rm = T) - 1, to = max(csk, na.rm = T) + 1, 
                bw = bw.c, adjust = 2, n = 256)
            p <- approx(d$x, rev(cumsum(rev(d$y))), csk)$y
        }
        else {
            p <- rep(1, attr(ratios, "ncol"))
        }
        return(p/sum(p, na.rm = T))
    }
    if (!is.null(c.scores) && !is.na(c.scores)) {
        cc.scores <- do.call(cbind, mc$apply(ks, get.cc.scores))
        cc.scores[is.infinite(cc.scores)] <- NA
        rownames(cc.scores) <- attr(ratios, "cnames")
    }
    invisible(list(r = rr.scores, c = cc.scores))
}
get.dup.seqs <-
function (seqs) 
{
    out <- duplicated(seqs)
    names(out) <- names(seqs)
    out
}
get.gene.coords <-
function (rows, op.shift = operon.shift, op.table = genome.info$operons) 
{
    rows <- unique(rows)
    syns <- get.synonyms(rows)
    ids <- lapply(syns, function(s) s[s %in% genome.info$feature.tab$id])
    if (all(sapply(ids, length) < 1)) {
        warning("Could not find gene start/stop for any input genes")
        return(NULL)
    }
    if (any(sapply(ids, length) < 1)) 
        warning("Could not find gene start/stop for all input genes")
    ids <- ids[sapply(ids, length) >= 1]
    ids <- sapply(ids, "[", 1)
    ids <- data.frame(id = ids, names = names(ids))
    coos <- NULL
    if (op.shift) {
        if (attr(op.table, "source") == "rsat") {
            ops <- merge(ids, op.table, by.x = "id", by.y = "query", 
                all = F)
            ops2 <- ops[order(ops$lead), ]
            coos <- merge(ops, genome.info$feature.tab, by.x = "lead", 
                by.y = "name", all = F)[, c("id.x", "names", 
                "contig", "strand", "start_pos", "end_pos")]
        }
        else if (attr(op.table, "source") == "microbes.online") {
            ops <- merge(ids, op.table, by.x = "names", by.y = "gene", 
                all.x = T)
            if (any(is.na(ops$head))) {
                head <- as.character(ops$head)
                head[is.na(head)] <- as.character(ops$names[is.na(head)])
                ops$head <- as.factor(head)
            }
            head.syns <- get.synonyms(unique(as.character(ops$head)))
            head.ids <- lapply(head.syns, function(s) s[s %in% 
                genome.info$feature.tab$id])
            head.ids <- head.ids[sapply(head.ids, length) >= 
                1]
            head.ids <- data.frame(id = sapply(head.ids, "[", 
                1), names = names(head.ids))
            ops2 <- merge(ops, head.ids, by.x = "head", by.y = "names", 
                all.x = T)
            coos <- merge(ops2, genome.info$feature.tab, by.x = "id.y", 
                by.y = "id", all.x = T)[, c("id.x", "names", 
                "contig", "strand", "start_pos", "end_pos")]
        }
    }
    else {
        coos <- merge(ids, genome.info$feature.tab, by = "id")[, 
            c("id", "names", "contig", "strand", "start_pos", 
                "end_pos")]
    }
    colnames(coos)[1] <- "id"
    if (is.factor(coos$start_pos)) 
        coos$start_pos <- as.numeric(levels(coos$start_pos))[coos$start_pos]
    if (is.factor(coos$end_pos)) 
        coos$end_pos <- as.numeric(levels(coos$end_pos))[coos$end_pos]
    coos
}
get.genome.info <-
function (fetch.upstream = F, fetch.predicted.operons = "rsat") 
{
    rsat.url <- rsat.urls[1]
    feature.tab <- feature.names <- genome.seqs <- operons <- org.id <- synonyms <- NULL
    fname <- paste("data/", rsat.species, "/organism_names.tab", 
        sep = "")
    genome.loc <- paste(rsat.url, "/data/genomes/", rsat.species, 
        "/genome/", sep = "")
    err <- dlf(fname, paste(genome.loc, "/organism_names.tab", 
        sep = ""))
    if (class(err) == "try-error") {
        tmp.url <- paste(rsat.url, "/data/genomes/", rsat.species, 
            "_EnsEMBL/genome/organism_names.tab", sep = "")
        err <- dlf(fname, tmp.url)
        if (class(err) != "try-error") 
            genome.loc <- paste(rsat.url, "/data/genomes/", rsat.species, 
                "_EnsEMBL/genome/", sep = "")
    }
    if (!file.exists(fname) || file.info(fname)$size <= 0) 
        stop(paste("Genome info for", rsat.species, "does not exist. Please check", 
            genome.loc, "and let me know if I am wrong"))
    nskip <- sum(substr(readLines(gzfile(fname), n = 20), 1, 
        2) == "--" | readLines(gzfile(fname), n = 20) == "")
    org.id <- read.delim(gzfile(fname), head = F, as.is = T, 
        skip = nskip)
    if (!exists("taxon.id") || is.na(taxon.id) || is.null(taxon.id)) 
        taxon.id <- org.id$V1[1]
    cat("Organism taxon id:", taxon.id, "\n")
    if (!no.genome.info) {
        fname <- paste("data/", rsat.species, "/feature.tab", 
            sep = "")
        use.cds <- FALSE
        err <- dlf(fname, paste(genome.loc, "feature.tab", sep = ""), 
            paste("Fetching genome data from RSAT", rsat.url, 
                "..."))
        if (class(err) == "try-error") {
            err <- dlf(fname, paste(genome.loc, "cds.tab", sep = ""))
            use.cds <- TRUE
        }
        head <- readLines(gzfile(fname), n = 30)
        nskip <- length(grep("^--", head))
        feature.tab <- read.delim(gzfile(fname), skip = nskip, 
            head = F, comment = "", as.is = F)
        head <- strsplit(gsub("^-- ", "", head[grep("^-- id", 
            head, perl = T)], perl = T), "\t")[[1]]
        colnames(feature.tab) <- head[1:ncol(feature.tab)]
        fname <- paste("data/", rsat.species, "/feature_names.tab", 
            sep = "")
        err <- dlf(fname, paste(genome.loc, if (!use.cds) 
            "feature_names.tab"
        else "cds_names.tab", sep = ""))
        nskip <- sum(substr(readLines(gzfile(fname), n = 20), 
            1, 2) == "--")
        feature.names <- read.delim(gzfile(fname), head = F, 
            as.is = T, skip = nskip, row.names = NULL, comment = "")
        colnames(feature.names) <- c("id", "names", "type")
        feature.names <- unique(feature.names)
        chroms <- unique(as.character(feature.tab$contig))
        chroms <- chroms[!is.na(chroms) & chroms != ""]
        if (!is.na(mot.iters[1])) {
            genome.seqs <- toupper(sapply(chroms, function(i) {
                cat("Loading genome sequence, chromosome", i, 
                  "\n")
                fname <- paste("data/", rsat.species, "/", i, 
                  ".raw", sep = "")
                err <- dlf(fname, paste(genome.loc, i, ".raw", 
                  sep = ""))
                if (class(err) == "try-error") {
                  ii <- gsub(":", "_", i, fixed = T)
                  err <- dlf(fname, paste(genome.loc, ii, ".raw", 
                    sep = ""))
                  if (class(err) == "try-error") {
                    err <- dlf(fname, paste(genome.loc, gsub(".[0-9]$", 
                      "", i), ".raw", sep = ""))
                    if (class(err) == "try-error") 
                      cat("ERROR reading genome sequence", i, 
                        "\n")
                  }
                }
                out <- try(readLines(gzfile(fname)), silent = T)
                if (class(out) == "try-error" || length(out) == 
                  0) 
                  cat("ERROR reading genome sequence", i, "\n")
                out
            }))
        }
        if (exists("ratios") && !is.null(ratios)) {
            cat("Gathering all \"standard\" orf names and other synonyms for all probe names...\n")
            tmp <- get.synonyms(attr(ratios, "rnames"), feature.names, 
                verbose = T)
            is.bad <- sapply(names(tmp), function(i) length(tmp[[i]]) == 
                0 || substr(tmp[[i]][1], 1, 5) == "Error")
            if (sum(is.bad) > 0) {
                cat("These", sum(is.bad), "probe names have no matching ORF annotation:\n")
                print(names(which(is.bad)))
            }
            cat("Mean number of synonyms per probe:", mean(sapply(tmp, 
                length), na.rm = T), "\n")
            synonyms <- tmp
            rm(tmp, is.bad)
        }
        if (!is.na(mot.iters[1]) && fetch.upstream) {
            fname <- paste("data/", rsat.species, "/upstream-noorf.fasta.gz", 
                sep = "")
            err <- dlf(fname, paste(genome.loc, rsat.species, 
                "_upstream-noorf.fasta.gz", sep = ""), "Fetching upstream sequences from RSAT...")
            upstream.noorf <- readLines(gzfile(fname))
            fname <- paste("data/", rsat.species, "/upstream.fasta.gz", 
                sep = "")
            err <- dlf(fname, paste(genome.loc, rsat.species, 
                "_upstream.fasta.gz", sep = ""))
            upstream <- readLines(gzfile(fname))
        }
    }
    invisible(list(species = rsat.species, genome.seqs = genome.seqs, 
        feature.tab = feature.tab, feature.names = feature.names, 
        org.id = org.id, taxon.id = taxon.id, synonyms = synonyms))
}
get.long.names <-
function (k, shorter = F) 
{
    if (is.numeric(k[1])) {
        rows <- get.rows(k)
    }
    else {
        rows <- k
    }
    if (is.null(genome.info$feature.tab)) {
        out <- rep("", length(rows))
        names(out) <- rows
        return(rows)
    }
    ids <- get.synonyms(rows)
    mc <- list(apply = lapply)
    if (!shorter) 
        desc <- mc$apply(ids, function(i) subset(genome.info$feature.tab, 
            id %in% i, select = c("id", "description")))
    else desc <- mc$apply(ids, function(i) subset(genome.info$feature.tab, 
        id %in% i, select = c("id", "name")))
    out <- sapply(desc, function(i) as.character(i[1, 2]))
    names(out) <- rows
    out[is.na(out) | out == names(out)] <- ""
    out
}
get.mast.pvals <-
function (mast.output, in.genes = NULL) 
{
    space.pad <- function(lines, length) {
        nc <- nchar(lines)
        nc[nc >= length] <- 0
        spaces <- sapply(1:length(lines), function(i) paste(rep(" ", 
            length - nc[i]), sep = "", collapse = ""))
        paste(lines, spaces)
    }
    out <- list()
    start <- grep("SECTION III: ANNOTATED SEQUENCES", mast.output)
    if (length(start) == 0 || is.na(start)) 
        return(out)
    end <- grep("\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*\\*", 
        mast.output[(start + 3):length(mast.output)]) + start + 
        3
    line.starts <- grep("LENGTH = ", mast.output[(start + 2):(start + 
        1 + end)]) + start + 1
    if (is.null(line.starts) || length(line.starts) == 0) 
        return(out)
    for (i in 1:length(line.starts)) {
        l <- line.starts[i]
        gene <- mast.output[l - 2]
        if (is.null(gene) || is.na(gene) || (!is.null(in.genes) && 
            !(gene %in% in.genes))) 
            next
        l.next <- line.starts[i + 1] - 2
        if (i >= length(line.starts)) 
            l.next <- end
        if (l.next - l <= 5) 
            next
        submast <- mast.output[l:(l.next - 1)]
        l.start <- which(submast == "")[1] + 1
        if (submast[l.start] == "") 
            l.start <- l.start + 1
        q <- list()
        for (i in 1:6) q[[i]] <- space.pad(submast[seq((l.start + 
            i - 1), length(submast), by = 6)], 80)
        seq.starts <- as.integer(sapply(strsplit(q[[5]], " "), 
            "[", 1))
        char.skip <- which(strsplit(q[[5]][1], "")[[1]] %in% 
            c("G", "A", "T", "C", "N", "X"))[1]
        mots <- unlist(strsplit(gsub("[\\[\\]\\<\\>]", "", paste(substr(q[[1]], 
            char.skip, 80), collapse = ""), perl = T), "\\s+", 
            perl = T))
        mots <- as.integer(mots[!is.na(as.integer(mots))])
        mots <- mots[!is.na(mots)]
        p.vals <- strsplit(paste(substr(q[[2]], char.skip, 80), 
            collapse = ""), "\\s+")[[1]]
        p.vals <- as.numeric(p.vals[!is.na(as.numeric(p.vals))])
        posns <- integer()
        for (i in 1:length(q[[1]])) {
            posns <- c(posns, which(strsplit(substr(q[[1]][i], 
                char.skip, 80), "")[[1]] %in% c("[", "<")) + 
                seq.starts[i])
        }
        out[[gene]] <- list(pvals = p.vals, mots = mots, posns = posns)
    }
    return(out)
}
get.motif.scores <-
function (k, seq.type = "upstream", for.rows = "all") 
{
    if (length(k) <= 0) 
        return(NULL)
    if (is.numeric(k[1])) 
        rows <- get.rows(k)
    else rows <- k
    if (for.rows[1] == "all") 
        for.rows <- attr(ratios, "rnames")
    if (length(rows) <= 1 || is.null(meme.scores[[seq.type]]$all.pv)) 
        return(rep(NA, length(for.rows)))
    m.scores <- log(meme.scores[[seq.type]]$all.pv[, k])
    m.scores <- m.scores[for.rows]
    return(m.scores)
}
get.network.scores <-
function (k, p1.col = "protein1", p2.col = "protein2", net = networks$string.links, 
    score.col = "combined_score", for.rows = "all") 
{
    if (length(k) <= 0) 
        return(NULL)
    if (is.numeric(k[1])) 
        rows <- get.rows(k)
    else rows <- k
    all.rows <- FALSE
    if (for.rows[1] == "all") {
        all.rows <- TRUE
        for.rows <- attr(ratios, "rnames")
    }
    if (length(rows) < 1) 
        return(rep(NA, length(for.rows)))
    cons <- net[as.character(net[[p1.col]]) %in% rows, c(p2.col, 
        score.col), drop = F]
    if (is.null(cons) || nrow(cons) <= 0) 
        return(rep(NA, length(for.rows)))
    cons <- cons[as.character(cons[[p2.col]]) %in% for.rows, 
        , drop = F]
    if (is.null(cons) || nrow(cons) <= 0) 
        return(rep(NA, length(for.rows)))
    tmp <- tapply(as.numeric(cons[[score.col]]), as.character(cons[[p2.col]]), 
        sum, na.rm = T)/length(rows)
    scores <- rep(NA, length(for.rows))
    names(scores) <- for.rows
    scores[names(tmp)] <- tmp
    return(-log(scores + 1))
}
get.operon.predictions <-
function (fetch.predicted.operons = "microbes.online", org.id = genome.info$org.id$V1[1]) 
{
    operons <- NULL
    if (fetch.predicted.operons == "rsat") {
        rsat.url <- rsat.urls[1]
        cat("Using operon predictions from RSAT...\n")
        fname <- paste("data/", rsat.species, "/rsat_operon_predictions.html", 
            sep = "")
        err <- dlf(fname, paste(rsat.url, "/infer-operons.cgi?organism=", 
            rsat.species, "&genes=all&return_leader=on&return_operon=on&return_query=on&", 
            "output=display&dist_thr=55", sep = ""), "Fetching operon predictions from RSAT...")
        operons <- readLines(gzfile(fname))
        start <- which(operons == "<INPUT type=\"hidden\" NAME=\"gene_selection\" VALUE=\"#lead\toperon\tquery") + 
            1
        end <- which(operons == "<INPUT type=\"hidden\" NAME=\"feattype\" VALUE=\"\">") - 
            2
        operons <- do.call(rbind, strsplit(operons[start:end], 
            "\t+", perl = T))
        colnames(operons) <- c("lead", "operon", "query")
        operons <- as.data.frame(operons)
    }
    else if (fetch.predicted.operons == "microbes.online") {
        cat("Using operon predictions from MicrobesOnline...\n")
        fname <- paste("data/", rsat.species, "/microbesonline_operons_gnc", 
            org.id, ".named", sep = "")
        err <- dlf(fname, paste("http://www.microbesonline.org/operons/gnc", 
            org.id, ".named", sep = ""), "Fetching operon predictions from MicrobesOnline...")
        if (org.id != taxon.id && (!file.exists(fname) || file.info(fname)$size == 
            0)) {
            fname <- paste("data/", rsat.species, "/microbesonline_operons_gnc", 
                taxon.id, ".named", sep = "")
            err <- dlf(fname, paste("http://www.microbesonline.org/operons/gnc", 
                taxon.id, ".named", sep = ""), "Fetching operon predictions from MicrobesOnline (2)...")
        }
        ops <- read.delim(gzfile(fname))
        ops2 <- subset(ops, bOp == "TRUE" & SysName1 != "" & 
            SysName2 != "")
        gns <- sort(unique(c(as.character(ops2$SysName1), as.character(ops2$SysName2))))
        gns <- gns[gns != ""]
        sn1 <- as.character(ops2$SysName1)
        sn1[sn1 == "" | is.na(sn1)] <- as.character(ops2$Name1)[sn1 == 
            "" | is.na(sn1)]
        sn2 <- as.character(ops2$SysName2)
        sn2[sn2 == "" | is.na(sn2)] <- as.character(ops2$Name2)[sn2 == 
            "" | is.na(sn2)]
        operons <- list(0)
        for (i in 1:length(sn1)) {
            sn1i <- sn1[i]
            found <- which(sapply(operons, function(j) sn1i %in% 
                j))
            if (length(found) > 0) 
                operons[[found[1]]] <- c(operons[[found[1]]], 
                  sn2[i])
            else operons[[length(operons) + 1]] <- c(sn1i, sn2[i])
        }
        operons <- operons[-1]
        search.names <- c(gns, as.character(genome.info$feature.names$id))
        if (exists("ratios")) 
            search.names <- c(attr(ratios, "rnames"), search.names)
        mc <- get.parallel(length(operons))
        nms <- mc$apply(1:length(operons), function(i) {
            s <- get.synonyms(operons[[i]])
            s <- lapply(s, function(i) i[i %in% search.names])
            ids <- unlist(lapply(s, function(i) i[i %in% genome.info$feature.names$id][1]))
            if (length(ids) <= 0) {
                warning(paste("No genome annotation for any genes in operon #", 
                  i, " -- don't know what to do!"))
                return("")
            }
            ids[is.na(ids)] <- names(ids)[is.na(ids)]
            vngs <- unlist(lapply(s, function(i) {
                out <- i[!i %in% genome.info$feature.names$id]
                if (length(out) <= 0 && exists("ratios")) 
                  out <- i[i %in% attr(ratios, "rnames")]
                if (length(out) <= 0) 
                  out <- i[genome.info$feature.names$id == i & 
                    genome.info$feature.names$id == "primary"]
                if (length(out) <= 0) 
                  out <- i
                out
            }))
            coos <- get.gene.coords(ids, op.shift = F)
            vngs <- vngs[ids %in% coos$names]
            if (is.null(coos) || nrow(coos) <= 0) {
                warning(paste("No genome annotation for any genes in operon #", 
                  i, " -- don't know what to do!"))
                return("")
            }
            if (mean(as.character(coos$strand) == "D") > 0.6) 
                head <- vngs[which.min(coos$start_pos)]
            else if (mean(as.character(coos$strand) == "R") > 
                0.6) 
                head <- vngs[which.max(coos$end_pos)]
            else {
                head <- ""
                warning(paste("About 50% of operon #", i, "are on opposite strands -- don't know what to do!"))
            }
            head
        })
        names(operons) <- unlist(nms)
        operons <- operons[names(operons) != ""]
        operons <- do.call(rbind, lapply(names(operons), function(h) data.frame(head = h, 
            gene = operons[[h]])))
        operons <- subset(operons, head != "")
    }
    if (!is.null(operons)) 
        attr(operons, "source") <- fetch.predicted.operons
    operons
}
get.parallel <-
function (X = k.clust, verbose = F) 
{
    if (is.na(parallel.cores) || (is.logical(parallel.cores) && 
        parallel.cores == FALSE) || multicore:::isChild() || 
        (is.numeric(parallel.cores) && parallel.cores <= 1)) {
        out <- list(mc = FALSE, par = parallel.cores, apply = lapply)
    }
    else {
        try(has.multi <- require(multicore))
        mc <- has.multi && !multicore:::isChild() && X > 1 && 
            !is.na(parallel.cores) && (is.numeric(parallel.cores) && 
            parallel.cores > 1) || (is.logical(parallel.cores) && 
            parallel.cores == TRUE)
        par <- parallel.cores
        out.apply <- lapply
        if (mc) {
            if (is.logical(par) && par == TRUE) 
                par <- multicore:::detectCores(all.tests = TRUE)
            par <- min(c(X, par, multicore:::detectCores(all.tests = TRUE)))
            if (verbose) 
                cat("PARALLELIZING:", par, "\n")
            out.apply <- mclapply
        }
        else {
            par <- NA
            if (verbose) 
                cat("NOT PARALLELIZING:", par, "\n")
        }
        out <- list(mc = mc, par = par, apply = out.apply)
    }
    if (is.numeric(out$par) && !is.na(out$par)) 
        options(cores = out$par)
    else if (is.na(out$par) || (is.logical(out$par) && out$par == 
        TRUE)) 
        options(cores = NULL)
    else options(cores = 1)
    out
}
get.predictome.links <-
function (org.id = organism) 
{
    out <- list()
    for (i in c("chromo", "comp", "fusion", "phylogenetic")) {
        fname <- paste("data/predictome/predictome_", i, "_links.txt", 
            sep = "")
        pred.file <- paste("http://predictome.bu.edu/data/all", 
            i, "links.txt", sep = "_")
        err <- dlf(fname, pred.file, paste("Reading in predictome links from", 
            pred.file))
        pred.tab <- read.delim(gzfile(fname), head = T, as.is = T)
        pred.tab <- pred.tab[pred.tab$species == org.id, ]
        out[[i]] <- data.frame(protein1 = pred.tab$orf_id_1, 
            protein2 = pred.tab$orf_id_2, combined_score = 1)
    }
    out
}
get.prolinks.links <-
function (org.id = genome.info$org.id$V1[1]) 
{
    fname <- paste("data/", rsat.species, "/prolinks_", gsub(" ", 
        "_", org.id), ".txt", sep = "")
    org.file <- paste("http://mysql5.mbi.ucla.edu/public/Genomes/", 
        gsub(" ", "_", org.id), ".txt", sep = "")
    err <- dlf(fname, org.file, paste("Fetching PROLINKS links from", 
        org.file))
    prol.tab <- read.delim(gzfile(fname), head = T, as.is = T)
    fname <- paste("data/prolinks_GeneID_Genename.txt", sep = "")
    err <- dlf(fname, "http://mysql5.mbi.ucla.edu/public/reference_files/GeneID_Genename.txt", 
        paste("Fetching PROLINKS genename ref. file from", id.file))
    id.tab <- read.delim(gzfile(fname), head = T, as.is = T)
    merged.tab <- merge(merge(prol.tab, id.tab, by.x = "gene_id_a", 
        by.y = "gene_id"), id.tab, by.x = "gene_id_b", by.y = "gene_id")
    out <- list()
    for (i in unique(merged.tab$method)) {
        out[[i]] <- merged.tab[merged.tab$method == i, c("name.x", 
            "name.y", "confidence")]
        colnames(out[[i]]) <- c("protein1", "protein2", "combined_score")
    }
    out
}
get.row.scores <-
function (k, cols = get.cols(k), for.rows = "all", ratios = ratios[[1]]) 
{
    if (length(k) <= 0) 
        return(NULL)
    if (is.numeric(k[1])) 
        rows <- get.rows(k)
    else rows <- k
    if (for.rows[1] == "all") 
        for.rows <- rownames(ratios)
    rows <- rows[rows %in% rownames(ratios)]
    cols <- cols[cols %in% colnames(ratios)]
    if (length(rows) < 1 || length(cols) <= 1) 
        return(rep(NA, length(for.rows)))
    rats <- ratios[for.rows, cols, drop = F]
    rats.mn <- colMeans(rats[rows, , drop = F], na.rm = T)
    rats.mn <- matrix(rats.mn, nrow = nrow(rats), ncol = ncol(rats), 
        byrow = T)
    rats <- rats - rats.mn
    rats <- rowMeans(abs(rats), na.rm = T)
    return(log(rats + 1e-99))
}
get.rows <-
function (k, rm = get("row.membership")) 
unique(rownames(which(rm == k, arr = T)))
get.sequences <-
function (k, seq.type = c("upstream", "upstream.noncod", "gene")[1], 
    distance = motif.upstream.search[[seq.type]], verbose = F) 
{
    if (is.null(genome.info$feature.tab)) 
        stop("Motif searching is on but no feature.tab!")
    if (length(k) <= 0) 
        return(NULL)
    if (is.numeric(k[1])) 
        rows <- get.rows(k)
    else rows <- k
    if (is.null(rows)) 
        return(NULL)
    op.shift <- operon.shift[seq.type]
    if (is.na(seq.type) || seq.type == "gene") 
        op.shift <- FALSE
    coos <- get.gene.coords(rows, op.shift)
    if (is.null(coos) || nrow(coos) <= 0) 
        return(NULL)
    coos <- subset(coos, !is.na(start_pos) & !is.na(end_pos))
    if (is.null(coos) || nrow(coos) <= 0) 
        return(NULL)
    seqs <- character()
    len <- distance
    for (i in 1:nrow(coos)) {
        if (seq.type == "gene") {
            st.st <- coos[i, c("start_pos", "end_pos"), drop = F]
        }
        else if (seq.type == "upstream" || seq.type == "upstream2") {
            st.st <- if (coos$strand[i] == "D") 
                c(coos$start_pos[i] - len[2] - 1, coos$start_pos[i] - 
                  1 - len[1])
            else c(coos$end_pos[i] + 1 + len[1], coos$end_pos[i] + 
                len[2] + 1)
        }
        else if (seq.type == "upstream.noncod") {
        }
        seq <- substr(genome.info$genome.seqs[as.character(coos$contig[i])], 
            st.st[1], st.st[2])
        if (coos$strand[i] == "R") 
            seq <- rev.comp(seq)
        seqs[as.character(coos$names[i])] <- seq
    }
    seqs <- seqs[rows]
    names(seqs) <- rows
    if (any(is.na(seqs))) {
        warning("Warning: could not find upstream sequences for all rows")
        seqs <- seqs[!is.na(seqs)]
    }
    remove.repeats <- remove.low.complexity.subseqs[seq.type]
    if (remove.repeats && length(grep("NNNNNN", seqs)) <= 1) {
        if (verbose) 
            cat("Removing low-complexity regions from sequences.\n")
        seqs <- remove.low.complexity(seqs, seq.type = seq.type)
    }
    seqs
}
get.stats <-
function (mean.func = median) 
{
    if (!exists("row.memb")) 
        row.memb <- t(apply(row.membership, 1, function(i) 1:k.clust %in% 
            i))
    if (!exists("col.memb")) 
        col.memb <- t(apply(col.membership, 1, function(i) 1:k.clust %in% 
            i))
    changed <- NA
    if (!is.null(old.row.membership)) 
        changed <- sum(row.memb != t(apply(old.row.membership, 
            1, function(i) 1:k.clust %in% i)), na.rm = T)
    resids <- sapply(clusterStack, "[[", "resid")
    if (is.matrix(resids)) 
        resids <- apply(resids, 1, mean.func, na.rm = T)
    else resids <- mean.func(resids, na.rm = T)
    p.clusts <- sapply(clusterStack, "[[", "p.clust")
    if (is.matrix(p.clusts)) 
        p.clusts <- apply(p.clusts, 1, mean.func, na.rm = T)
    else p.clusts <- mean.func(p.clusts, na.rm = T)
    out <- data.frame(iter = iter, changed = changed, row.scores = mean(row.scores[row.memb], 
        na.rm = T, trim = 0.05), col.scores = mean(col.scores[, 
        ][col.memb], na.rm = T, trim = 0.05), mot.scores = if (!is.null(mot.scores)) 
        mean.func(mot.scores[, ][row.memb], na.rm = T)
    else NA, net.scores = if (!is.null(net.scores)) 
        mean(net.scores[, ][row.memb], na.rm = T, trim = 0.05)
    else NA, resid = weighted.mean(resids, resid.weights, na.rm = T), 
        nrow = mean.func(sapply(clusterStack, "[[", "nrows"), 
            na.rm = T), ncol = mean.func(sapply(clusterStack, 
            "[[", "ncols"), na.rm = T), p.clust = weighted.mean(p.clusts, 
            mot.weights, na.rm = T))
    if (length(resids) > 1) 
        for (i in names(resids)) {
            out <- cbind(out, resids[i])
            names(out)[ncol(out)] <- paste("resid", i, sep = ".")
        }
    if (length(p.clusts) > 1) 
        for (i in names(p.clusts)) {
            out <- cbind(out, p.clusts[i])
            names(out)[ncol(out)] <- paste("p.clust", i, sep = ".")
        }
    if (length(networks) > 1) {
        for (i in names(networks)) {
            if (exists("cluster.net.scores")) 
                out <- cbind(out, mean(cluster.net.scores[, i], 
                  na.rm = T, trim = 0.05))
            else out <- cbind(out, NA)
            names(out)[ncol(out)] <- paste("net", i, sep = ".")
        }
    }
    out
}
get.synonyms <-
function (gns, ft = genome.info$feature.names, ignore.case = T, 
    verbose = F, fast = F, force = F) 
{
    if (exists("no.genome.info") && no.genome.info) {
        out <- as.list(gns)
        names(out) <- gns
        return(out)
    }
    out <- list()
    if (!force && exists("genome.info") && !is.null(genome.info$synonyms)) {
        gns.cached <- gns[gns %in% names(genome.info$synonyms)]
        out <- genome.info$synonyms[gns.cached]
        gns <- gns[!gns %in% names(genome.info$synonyms)]
        if (length(gns) <= 0) 
            return(out)
    }
    tmp.out <- as.list(gns)
    names(tmp.out) <- gns
    if (is.null(ft)) 
        return(tmp.out)
    gns.orig <- gns
    gns <- gsub("m$|_\\d$|\\-\\S$", "", gns, perl = T)
    gns <- gsub("([\\[\\]\\(\\)\\{\\}\\.\\+\\-'\"])", "\\\\\\1", 
        gns, perl = T)
    gns <- gns[!is.na(gns) & gns != ""]
    ft <- ft[, c("id", "names")]
    if (exists("translation.tab") && !is.null(translation.tab)) 
        ft <- rbind(ft, data.frame(id = as.character(translation.tab$V1), 
            names = as.character(translation.tab$V2)))
    ft <- subset(ft, names != "")
    if (verbose) 
        ggggg <- gns[seq(100, length(gns), by = 100)]
    mc <- get.parallel(length(gns), verbose = F)
    tmp <- mc$apply(gns, function(g) {
        if (verbose && g %in% ggggg) 
            cat(" ...", g)
        greg <- paste("^", g, sep = "")
        tmp <- subset(ft, grepl(greg, id, perl = T, ignore = ignore.case) | 
            grepl(greg, names, perl = T, ignore = ignore.case))
        if (nrow(tmp) <= 0) 
            return(g)
        tmp2 <- unique(c(g, as.character(tmp$id), as.character(tmp$names)))
        if (!fast) {
            tmp2 <- subset(ft, id %in% tmp2 | names %in% tmp2)
            tmp2 <- unique(c(g, as.character(tmp2[, 1]), as.character(tmp2[, 
                2])))
        }
        tmp2 <- gsub("\\\\([\\[\\]\\(\\)\\{\\}\\.\\+\\-'\"])", 
            "\\1", tmp2, perl = T)
        tmp2
    })
    names(tmp) <- gns.orig
    if (verbose) 
        cat("\n")
    c(tmp, out)
}
get.updated.memberships <-
function () 
{
    n.rows <- tabulate(row.membership)
    rm <- t(apply(rr.scores, 1, order, decreasing = T)[1:n.clust.per.row[iter], 
        , drop = F])
    rm <- t(apply(rm, 1, sort))
    if (n.clust.per.row[iter] == 1) 
        rm <- t(rm)
    cra <- cluster.rows.allowed
    for (i in 1:nrow(rm)) {
        if (all(rm[i, ] %in% row.membership[i, ])) 
            next
        mc <- max.changes["rows"]
        if (mc < 1 && mc > 0 && runif(1) > mc) 
            next
        else mc <- 1
        if (sum(!rm[i, ] %in% row.membership[i, ]) >= mc) {
            if (any(row.membership[i, ] == 0)) {
                col.change <- which(row.membership[i, ] == 0)[1]
            }
            else {
                ttmp <- tabulate(row.membership[i, ])
                if (any(ttmp > 1)) {
                  col.change <- which(row.membership[i, ] %in% 
                    which(ttmp > 1))[1]
                }
                else {
                  delta <- rr.scores[i, rm[i, ]] - rr.scores[i, 
                    row.membership[i, ]]
                  if (any(row.membership[i, ] %in% rm[i, ])) 
                    delta[row.membership[i, ] %in% rm[i, ]] <- 0
                  if (all(is.na(delta) | delta <= 0)) 
                    next
                  col.change <- which.max(delta)
                }
            }
            if (!rm[i, col.change] %in% row.membership[i, ]) 
                row.membership[i, col.change] <- rm[i, col.change]
        }
    }
    n.cols <- tabulate(col.membership)
    cm <- t(apply(cc.scores, 1, order, decreasing = T)[1:n.clust.per.col[iter], 
        , drop = F])
    for (i in 1:nrow(cm)) {
        mc <- max.changes["cols"]
        if (mc < 1 && mc > 0 && runif(1) > mc) 
            next
        else mc <- 1
        if (sum(!cm[i, ] %in% col.membership[i, ]) >= mc) {
            if (any(col.membership[i, ] == 0)) {
                col.change <- which(col.membership[i, ] == 0)[1]
            }
            else {
                ttmp <- tabulate(col.membership[i, ])
                if (any(ttmp > 1)) {
                  col.change <- which(col.membership[i, ] %in% 
                    which(ttmp > 1))[1]
                }
                else {
                  delta <- cc.scores[i, cm[i, ]] - cc.scores[i, 
                    col.membership[i, ]]
                  if (all(is.na(delta) | delta <= 0)) 
                    next
                  col.change <- which.max(delta)
                }
            }
            col.membership[i, col.change] <- cm[i, col.change]
        }
    }
    invisible(list(r = row.membership, c = col.membership))
}
getMastPValuesAndEValues <-
function (mastOutput, get.p.values = NULL) 
{
    lines <- grep("COMBINED P-VALUE", mastOutput)
    if (length(lines) > 0) {
        splitted <- strsplit(mastOutput[lines], "[\\t\\s]+", 
            perl = T)
        out <- t(sapply(1:length(lines), function(i) {
            gene <- mastOutput[lines[i] - 2]
            splt <- splitted[[i]]
            p.val <- splt[8]
            e.val <- splt[11]
            c(gene = gene, p.value = p.val, e.value = e.val)
        }))
        out <- data.frame(gene = out[, "gene"], p.value = as.numeric(out[, 
            "p.value"]), e.value = as.numeric(out[, "e.value"]))
    }
    out2 <- data.frame()
    if (!is.null(get.p.values) && !is.na(get.p.values)) {
        tmp <- get.mast.pvals(mastOutput, in.genes = get.p.values)
        for (g in names(tmp)) {
            pv <- as.numeric(tmp[[g]]$pvals)
            pos <- as.integer(tmp[[g]]$posns)
            mots <- as.integer(tmp[[g]]$mots)
            if (!all(c(length(pv), length(pos)) == length(mots))) 
                pv <- c(pv, rep(pv[1], length(pos) - length(pv)))
            out2 <- rbind(out2, data.frame(gene = g, pvals = pv, 
                posns = pos, mots = mots))
        }
    }
    return(list(out, out2))
}
getMemeMotifInfo <-
function (memeOutput) 
{
    out <- list()
    lines <- grep("^MOTIF\\s+\\d", memeOutput, perl = T)
    if (length(lines) <= 0) 
        lines <- grep("^MOTIF\\s+", memeOutput, perl = T)
    if (length(lines) > 0) {
        pssms <- getMemeMotifPssm(memeOutput, n.motif = length(lines))
        splitted <- strsplit(memeOutput[lines], "[\\t\\s]+", 
            perl = T)
        for (i in 1:length(lines)) {
            splt <- splitted[[i]]
            motif <- as.integer(splt[2])
            width <- as.integer(splt[5])
            sites <- as.integer(splt[8])
            llr <- as.integer(splt[11])
            e.value <- as.numeric(sub("\\+", "", splt[14]))
            pssm <- pssms[[motif]]$pssm
            l2 <- grep(paste("Motif", motif, "sites sorted by position p-value"), 
                memeOutput) + 4
            l3 <- grep("--------------------------------------------------------------------------------", 
                memeOutput[(l2 + 1):length(memeOutput)])[1] + 
                l2 - 1
            posns <- do.call(rbind, strsplit(memeOutput[l2:l3], 
                "[\\t\\s]+", perl = T))[, c(1:4, 6)]
            colnames(posns) <- c("gene", "strand", "start", "p.value", 
                "site")
            posns <- data.frame(gene = posns[, "gene"], strand = posns[, 
                "strand"], start = as.integer(posns[, "start"]), 
                p.value = as.numeric(posns[, "p.value"]), site = posns[, 
                  "site"])
            out[[motif]] <- list(width = width, sites = sites, 
                llr = llr, e.value = e.value, pssm = pssm, posns = posns)
        }
    }
    out
}
getMemeMotifPssm <-
function (memeOut, n.motif = 1) 
{
    pssms <- list()
    for (i in 1:n.motif) {
        m.line1 <- grep(paste("Motif ", i, " position-specific probability matrix", 
            sep = ""), memeOut)
        if (length(m.line1) > 0) {
            m.desc <- strsplit(memeOut[m.line1 + 2], " ")[[1]]
            winLen <- as.numeric(m.desc[6])
            e.val <- as.numeric(m.desc[10])
            pssm <- do.call(rbind, strsplit(memeOut[m.line1 + 
                2 + 1:winLen], "\\s+", perl = T))[, 2:5]
            pssm <- matrix(as.numeric(pssm), nrow = winLen, ncol = 4, 
                byrow = F)
            pssms[[i]] <- list(pssm = pssm, e.val = e.val)
        }
        else {
            pssms[[i]] <- list(pssm = NULL, e.val = 99999)
        }
    }
    return(pssms)
}
id.duplicate.clusters <-
function (scores = r.scores, cor.cutoff = 0.9) 
{
    cors <- cor(scores, use = "pairwise", method = "pearson")
    cors[lower.tri(cors, diag = T)] <- NA
    tmp <- which(cors >= cor.cutoff, arr = T)
    cbind(tmp, cors[tmp])
}
load.ratios <-
function (ratios) 
{
    if (is.null(ratios)) 
        return(NULL)
    if (is.character(ratios) && file.exists(ratios)) {
        cat("Loading ratios file", ratios, "\n")
        ratios <- read.delim(file = gzfile(ratios), sep = "\t", 
            as.is = T, header = T)
    }
    if (is.matrix(ratios) || is.data.frame(ratios)) {
        if (class(ratios[, 1]) == "character") {
            ratios <- ratios[!duplicated(ratios[, 1]), ]
            rownames(ratios) <- attr(ratios, "rnames") <- ratios[, 
                1]
            ratios <- ratios[, -1]
        }
        if (class(ratios[, 1]) == "character") 
            ratios <- ratios[, -1]
    }
    cat("Original ratios matrix is", paste(dim(ratios), collapse = "x"), 
        "\n")
    if (!is.matrix(ratios)) 
        ratios <- as.matrix(ratios)
    if (is.null(attr(ratios, "isPreProcessed")) || attr(ratios, 
        "isPreProcessed") == FALSE) {
        ratios <- preprocess.ratios(ratios)
        attr(ratios, "isPreProcessed") <- TRUE
    }
    ratios
}
load.sif.interactions <-
function (sif.fname) 
{
    sif <- read.delim(gzfile(sif.fname), sep = "", head = F, 
        comment = "#")
    contains.weights <- ncol(sif) == 3 && any(sapply(1:ncol(sif), 
        function(i) is.numeric(sif[, i])))
    if (contains.weights) {
        weight.col <- which(sapply(1:ncol(sif), function(i) is.numeric(sif[, 
            i])))
        if (length(weight.col) == 1) {
            sif[, weight.col] <- sif[, weight.col] * 1000/max(sif[, 
                weight.col], na.rm = T)
            if (weight.col == 1) 
                sif <- sif[, c(2, 1, 3)]
            else if (weight.col == 3) 
                sif <- sif[, c(1, 3, 2)]
            colnames(sif) <- c("V1", "V2", "V3")
        }
    }
    else if (ncol(sif) == 3) {
        sif <- data.frame(V1 = sif$V1, V2 = rep(1000, nrow(sif)), 
            V3 = sif$V3)
    }
    else {
        sif <- data.frame(V1 = sif$V1, V2 = rep(1000, nrow(sif)), 
            V3 = sif$V2)
    }
    sif$V2[is.na(sif$V2)] <- 0
    sif <- sif[, c("V1", "V3", "V2")]
    colnames(sif) <- c("protein1", "protein2", "combined_score")
    sif
}
meme.all.clusters <-
function (ks = 1:k.clust, verbose = T, seq.type = "upstream", 
    ...) 
{
    out.ms <- meme.scores[[seq.type]]
    mc <- get.parallel(length(ks), verbose = T)
    out.ms <- if (mc$mc) 
        mc$apply(ks, FUN = function(k) meme.one.cluster(k, verbose = F, 
            seq.type = seq.type, ...), mc.preschedule = F)
    else mc$apply(ks, FUN = function(k) try(meme.one.cluster(k, 
        verbose = F, seq.type = seq.type, ...)))
    out.ms[[k.clust + 1]] <- ""
    for (k in ks) {
        if (length(out.ms) < k || is.null(out.ms[[k]]) || class(out.ms[[k]]) == 
            "try-error" || out.ms[[k]]$k != k || (!is.null(out.ms[[k]]$iter) && 
            out.ms[[k]]$iter != iter)) {
            out <- try(meme.one.cluster(k, verbose = T, seq.type = seq.type, 
                ...))
        }
        else {
            out <- out.ms[[k]]
        }
        if (class(out) == "try-error") 
            out <- try(meme.one.cluster(k, verbose = T, seq.type = seq.type, 
                ...))
        if (class(out) == "try-error" || is.null(out) || out$k != 
            k) {
            cat("ERROR on cluster", k, "\n")
            out <- list()
        }
        else if (verbose) {
            cat(iter, k, length(get.rows(k)), seq.type, "\t")
        }
        if (verbose) {
            if (is.null(out) || is.null(out$meme.out)) 
                cat("Inf \n")
            else cat(k, sapply(out$meme.out, "[[", "e.value"), 
                if (!is.null(out$pv.ev)) 
                  mean(log10(out$pv.ev[[1]][rownames(out$pv.ev[[1]]) %in% 
                    get.rows(k), "p.value"]), na.rm = T)
                else "Inf", "\t", pssm.to.string(out$meme.out[[1]]$pssm), 
                "\n")
        }
        out$iter <- iter
        out$k <- k
        out.ms[[k]] <- out
    }
    mot.rows <- character()
    for (k in 1:k.clust) {
        if (is.null(out.ms[[k]]$pv.ev)) 
            next
        mot.rows <- unique(c(mot.rows, rownames(out.ms[[k]]$pv.ev[[1]])))
    }
    mot.rows <- sort(mot.rows)
    out.pv <- out.ev <- NULL
    for (k in 1:k.clust) {
        m <- out.ms[[k]]
        if (is.null(m) || is.null(m$pv.ev)) {
            out.pv <- cbind(out.pv, rep(NA, length(mot.rows)))
            out.ev <- cbind(out.ev, rep(NA, length(mot.rows)))
        }
        else {
            m.scores <- numeric(length = length(mot.rows))
            tmp <- m$pv.ev[[1]][, "p.value"]
            names(tmp) <- rownames(m$pv.ev[[1]])
            m.scores <- tmp[mot.rows]
            out.pv <- cbind(out.pv, m.scores)
            colnames(out.pv) <- NULL
            m.scores <- numeric(length = length(mot.rows))
            tmp <- m$pv.ev[[1]][, "e.value"]
            names(tmp) <- rownames(m$pv.ev[[1]])
            m.scores <- tmp[mot.rows]
            out.ev <- cbind(out.ev, m.scores)
            colnames(out.ev) <- NULL
            out.ms[[k]]$pv.ev[[1]] <- NULL
        }
    }
    rownames(out.pv) <- mot.rows
    if (!is.null(out.pv)) 
        rownames(out.pv) <- mot.rows
    out.ms$all.pv <- out.pv
    attr(out.ms, "seq.type") <- seq.type
    out.ms
}
meme.one.cluster <-
function (k, verbose = F, addl.args = "", seq.type = "upstream", 
    pseudocount = 1/length(get.rows(k)), ms = meme.scores[[seq.type]][[k]], 
    ...) 
{
    if (is.numeric(k)) 
        rows <- get.rows(k)
    else rows <- k
    seqs <- get.sequences(rows, seq.type = seq.type)
    if (is.null(seqs) || length(seqs) < meme.seqs.allowed[[seq.type]][1]) 
        return(list(k = k))
    uniq <- uniquify.seqs[seq.type]
    if (uniq) 
        seqs <- seqs[!get.dup.seqs(seqs)]
    if (length(seqs) < meme.seqs.allowed[[seq.type]][1] || length(seqs) > 
        meme.seqs.allowed[[seq.type]][2]) 
        return(list(k = k))
    meme.out <- mast.out <- NULL
    all.seqs <- genome.info$all.upstream.seqs[[seq.type]]
    if (is.null(all.seqs)) 
        all.seqs <- get.sequences("all", seq.type = seq.type, 
            distance = motif.upstream.scan[[seq.type]])
    bg.list <- genome.info$bg.list[[seq.type]]
    if (is.null(bg.list) && !is.na(bg.order[seq.type])) {
        tmp.seqs <- all.seqs[!names(all.seqs) %in% rows]
        if (uniq) 
            tmp.seqs <- tmp.seqs[!get.dup.seqs(seqs)]
        capture.output(bg.list <- mkBgFile(tmp.seqs, order = bg.order[seq.type], 
            use.rev.comp = grepl("-revcomp", meme.addl.args[i])))
        rm(tmp.seqs)
    }
    pal.opt <- motif.palindrome.option[seq.type]
    addl.args <- paste(addl.args, meme.addl.args[seq.type])
    addl.args <- sprintf(addl.args, n.motifs[[seq.type]][iter], 
        min.motif.width[[seq.type]][iter], max.motif.width[[seq.type]][iter])
    consensus <- meme.consensus[seq.type]
    if (is.na(consensus)) 
        consensus <- if (iter > 500) 
            "compute"
        else ""
    if (consensus == "compute" && !is.null(ms) && !is.null(ms$meme.out)) {
        e.val <- sapply(1:length(ms$meme.out), function(i) ms$meme.out[[i]]$e.value)
        if (min(e.val, na.rm = T) < meme.consensus.e.val.limit[seq.type]) {
            best <- which.min(e.val)
            consensus <- toupper(pssm.to.string(ms$meme.out[[best]]$pssm))
        }
    }
    if (!is.null(consensus) && !is.na(consensus) && consensus != 
        "compute" && consensus != "") 
        addl.args <- paste(addl.args, "-cons", consensus)
    runMemePal <- function(sgenes, seqs, addl.args = "", ...) runMeme(sgenes, 
        seqs, addl.args = paste("-pal", addl.args), ...)
    runMemePalNonPal <- function(sgenes, seqs, addl.args = "", 
        ...) list(non = runMeme(sgenes, seqs, addl.args = addl.args, 
        ...), pal = runMemePal(sgenes, seqs, addl.args = addl.args, 
        ...))
    cat(k, "\t", Sys.getpid(), date(), "\t\t", seq.type, "\tSEQUENCES:", 
        length(seqs), "\n")
    run.meme <- runMeme
    if (pal.opt == "both") 
        run.meme <- runMemePalNonPal
    else if (pal.opt == "pal") 
        run.meme <- runMemePal
    if (verbose) {
        meme.out <- try(run.meme(names(seqs), seqs, nmotif = n.motifs[[seq.type]][iter], 
            verbose = verbose, bg.list = bg.list, addl.args = addl.args, 
            ...))
    }
    else {
        capture.output(meme.out <- try(run.meme(names(seqs), 
            seqs, nmotif = n.motifs[[seq.type]][iter], verbose = verbose, 
            bg.list = bg.list, addl.args = addl.args, ...)))
    }
    if (pal.opt == "both") {
        meme.out2 <- lapply(meme.out, getMemeMotifInfo)
        e.vals <- sapply(lapply(meme.out2, sapply, "[[", "e.value"), 
            min, na.rm = T)
        if (verbose) 
            cat(k, "Using pal/non-pal motif:", e.vals, names(which.min(e.vals)), 
                "\n")
        meme.out <- meme.out[[which.min(e.vals)]]
        meme.out2 <- meme.out2[[which.min(e.vals)]]
        attr(meme.out2, "is.pal") <- names(which.min(e.vals)) == 
            "pal"
    }
    else {
        meme.out2 <- getMemeMotifInfo(meme.out)
        attr(meme.out2, "is.pal") <- FALSE
    }
    if (length(meme.out2) <= 0) 
        return(list(k = k))
    if (verbose) 
        mast.out <- try(runMast(meme.out, names(all.seqs), all.seqs, 
            verbose = verbose, addl.args = mast.addl.args[seq.type], 
            bg.list = bg.list, ...))
    else capture.output(mast.out <- try(runMast(meme.out, names(all.seqs), 
        all.seqs, verbose = verbose, addl.args = mast.addl.args[seq.type], 
        bg.list = bg.list, ...)))
    pv.ev <- NULL
    if (length(grep("Error reading log-odds matrix file", mast.out)) <= 
        0 && class(meme.out) != "try-error" && class(mast.out) != 
        "try-error" && length(meme.out2) > 0 && length(mast.out) > 
        0) {
        pv.ev <- getMastPValuesAndEValues(mast.out, get.p.values = rows)
        if (length(pv.ev) > 0 && nrow(pv.ev[[1]]) == 0 && nrow(pv.ev[[2]]) == 
            0) {
            pv.ev <- NULL
        }
        else {
            for (i in 1) {
                tmp <- as.matrix(pv.ev[[i]][, 2:ncol(pv.ev[[i]])])
                rownames(tmp) <- pv.ev[[i]][, 1]
                pv.ev[[i]] <- tmp
            }
        }
    }
    invisible(list(k = k, meme.out = meme.out2, pv.ev = pv.ev))
}
mkBgFile <-
function (bgseqs = NULL, order = 0, bgfname = NULL, input.list = NULL, 
    use.rev.comp = T, verbose = T) 
{
    if (!is.null(input.list) && !is.null(bgfname)) {
        tmp <- unlist(input.list[2:length(input.list)])
        tmp2 <- sprintf("%.8f", tmp)
        names(tmp2) <- names(tmp)
        write.table(tmp2, row.names = names(tmp2), col.names = paste("#", 
            order, "th order Markov background model"), quote = F, 
            file = bgfname)
        return(input.list)
    }
    repl <- list(R = c("G", "A"), Y = c("T", "C"), K = c("G", 
        "T"), M = c("A", "C"), S = c("G", "C"), W = c("A", "T"), 
        N = c("G", "A", "T", "C"))
    bad.seqs <- grep("[^GATCX]", bgseqs, perl = T)
    if (length(bad.seqs) > 0) {
        if (verbose) 
            cat(length(bad.seqs), "sequences with degenerate residues...fixing.\n")
        for (i in bad.seqs) {
            tmp <- strsplit(bgseqs[i], character(0))[[1]]
            inds <- grep("[^GATCX]", tmp, perl = T)
            for (ind in inds) tmp[ind] <- sample(repl[[tmp[ind]]], 
                1)
            bgseqs[i] <- paste(tmp, collapse = "")
        }
    }
    if (verbose) 
        cat("Calculating", order, "th order background Markov model from", 
            length(bgseqs), "sequences\n")
    if (use.rev.comp && verbose) 
        cat("Using reverse-complement too.\n")
    bgseqs <- unique(bgseqs)
    if (use.rev.comp) 
        bgseqs <- unique(c(bgseqs, rev.comp(bgseqs)))
    mc <- get.parallel(order + 1)
    apply.func <- lapply
    tmp <- mc$apply(0:order, function(ord, mc.cores) {
        out <- list()
        if (verbose) 
            cat("Calculating", ord, "th order part of background Markov model from", 
                length(bgseqs), "sequences\n")
        if (ord == 0) {
            all.substrings <- unlist(strsplit(bgseqs, character(0)), 
                use.names = F)
        }
        else {
            all.substrings <- sapply(1:(max(nchar(bgseqs)) - 
                ord), function(i) substr(bgseqs, i, i + ord))
            all.substrings <- as.vector(all.substrings)
        }
        all.substrings <- all.substrings[!is.na(all.substrings) & 
            all.substrings != "" & nchar(all.substrings) == ord + 
            1]
        counts <- table(as.factor(all.substrings))
        counts <- sort(counts)
        counts <- counts/length(all.substrings)
        counts <- counts[grep("N", names(counts), val = T, invert = T)]
        out <- as.list(counts)
        for (i in names(out)) {
            names(out[[i]]) <- NULL
            if (verbose && ord <= 3) 
                cat("FREQ:", i, "=", counts[i], "\n")
        }
        out
    }, mc.cores = min(order + 1, mc$par))
    out <- list()
    out$order <- order
    for (i in 1:length(tmp)) for (j in 1:length(tmp[[i]])) out[[names(tmp[[i]])[j]]] <- tmp[[i]][[j]]
    if (!is.null(bgfname) && !file.exists(bgfname)) {
        cat("Writing to file:", bgfname, "\n")
        tmp <- unlist(out)
        tmp <- tmp[2:length(tmp)]
        tmp2 <- sprintf("%.8f", tmp)
        names(tmp2) <- names(out)[2:length(out)]
        write.table(tmp2, row.names = names(tmp2), col.names = paste("#", 
            order, "th order Markov background model"), quote = F, 
            file = bgfname)
    }
    invisible(out)
}
mkTempMemeFiles <-
function (sgenes, seqs, seq.weights = NA, fname = "meme.tmp.fst", 
    bgseqs = NULL, bgfname = NULL, bg.list = NULL, force.overwrite = F, 
    seq.type = "upstream") 
{
    if (!file.exists(fname) || force.overwrite) {
        sgenes <- sgenes[!(is.na(seqs) | is.null(seqs) | seqs == 
            "")]
        seqs <- seqs[!(is.na(seqs) | is.null(seqs) | seqs == 
            "")]
        sgenes <- sgenes[nchar(seqs) >= motif.width.range[[seq.type]][2]]
        seqs <- seqs[nchar(seqs) >= motif.width.range[[seq.type]][2]]
        lengths <- sum(nchar(seqs)) + length(seqs) * 3
        if (!is.na(seq.weights)) {
            seq.weights <- seq.weights[sgenes]
            seq.weights[is.na(seq.weights)] <- 0
            cat(paste(">WEIGHTS", paste(seq.weights, collapse = " ")), 
                paste(">", sgenes, "\n", seqs, sep = ""), file = fname, 
                sep = "\n")
        }
        else {
            cat(paste(">", sgenes, "\n", seqs, sep = ""), file = fname, 
                sep = "\n")
        }
    }
    if (force.overwrite || (!is.null(bgfname) && !file.exists(bgfname))) {
        if (!is.null(bg.list)) 
            mkBgFile(input.list = bg.list, order = bg.list$order, 
                bgfname = bgfname)
        else if (!is.null(bgseqs)) 
            mkBgFile(bgseqs, order = 0, bgfname = bgfname)
    }
    length(seqs)
}
pareto.adjust.weights <-
function (iter, delta.iter = 200, delta.factor = 1, n.avg = 50, 
    max.delta = 0.05) 
{
    if (iter == 1) 
        return(c(row = resid.scaling[iter], mot = mot.scaling[iter], 
            net = net.scaling[iter]))
    out.scaling <- c(row = resid.scaling[iter - 1], mot = mot.scaling[iter - 
        1], net = net.scaling[iter - 1])
    if (iter < delta.iter + n.avg + 10) 
        return(out.scaling)
    all.diffs <- numeric()
    for (i in c("row", "mot", "net")) {
        if (i == "row") 
            col <- "resid"
        else if (i == "mot") 
            col <- "p.clust"
        else col <- paste(i, "scores", sep = ".")
        tops <- stats[[col]][(iter - n.avg + 1):iter]
        bots <- stats[[col]][(iter - n.avg + 1):iter - delta.iter]
        all.diffs[i] <- mean(tops - bots, na.rm = T)/abs(diff(range(stats[[col]], 
            na.rm = T)))
    }
    for (i in which(all.diffs > 0 & !is.na(all.diffs) & !is.na(out.scaling) & 
        out.scaling > 0)) out.scaling[names(all.diffs)[i]] <- out.scaling[names(all.diffs)[i]] + 
        min(c(out.scaling[i] * max.delta, all.diffs[i] * delta.factor))
    out.scaling
}
plot.scores <-
function (k, o.genes = NULL) 
{
    row.memb <- apply(row.membership == k, 1, any)
    opar <- par(no.readonly = T)
    rows <- get.rows(k)
    tmp.scale <- round(attr(ratios, "nrow")/length(rows)/4)
    layout(matrix(c(1, 2, 3, 4, 4, 5, 4, 4, 6), 3, 3, byrow = T))
    rs <- row.scores[, k]
    rs[rs < -220] <- min(rs[rs > -220], na.rm = T)
    h <- try(hist(rs, breaks = 20, main = paste("Cluster", k), 
        xlab = "Ratios scores"))
    if (class(h) != "try-error") {
        try(hist(rep(rs[rows], tmp.scale), breaks = h$breaks, 
            col = "red", border = "red", add = T))
        try(hist(rs, breaks = h$breaks, add = T))
    }
    ms <- ns <- NULL
    if (!is.null(mot.scores) && !all(is.na(mot.scores[, k]))) {
        ms <- mot.scores[, k]
        ms[ms < -20] <- min(ms[ms > -20], na.rm = T)
        h <- try(hist(ms, breaks = 20, main = NULL, xlab = "Motif scores"))
        if (class(h) != "try-error") {
            try(hist(rep(ms[rows], tmp.scale * 3), breaks = h$breaks, 
                col = "red", border = "red", add = T))
            try(hist(ms, breaks = h$breaks, add = T))
        }
    }
    else plot(1, 1, typ = "n", axes = F, xaxt = "n", yaxt = "n", 
        xlab = "", ylab = "")
    if (!is.null(net.scores)) {
        ns <- net.scores[, k]
        ns[ns < -20] <- min(ns[ns > -20], na.rm = T)
        ns <- -log10(-ns)
        h <- try(hist(ns, breaks = 20, main = NULL, xlab = "-log10(-Network scores)"))
        if (class(h) != "try-error") {
            try(hist(rep(ns[rows], tmp.scale/3), breaks = h$breaks, 
                col = "red", border = "red", add = T))
            try(hist(ns, breaks = h$breaks, add = T))
        }
    }
    else plot(1, 1, typ = "n", axes = F, xaxt = "n", yaxt = "n", 
        xlab = "", ylab = "")
    if (!is.null(ms) && !all(is.na(ms))) {
        plot(rs, ms, typ = "n", main = paste("Cluster", k), xlab = "Ratios scores", 
            ylab = "Mot scores")
        text(rs, ms, label = 1:length(rs), col = row.memb + 1, 
            cex = 0.5)
    }
    else if (!is.null(ns) && !all(is.na(ns))) {
        plot(rs, ns, typ = "n", main = paste("Cluster", k), xlab = "Ratios scores", 
            ylab = "Net scores")
        text(rs, ns, label = 1:length(rs), col = row.memb + 1, 
            cex = 0.5)
    }
    else {
        plot(rs, jitter(rep(0, length(rs))), typ = "n", main = paste("Cluster", 
            k), xlab = "Ratios scores", ylab = "")
        text(rs, jitter(rep(0, length(rs))), label = 1:length(rs), 
            col = row.memb + 1, cex = 0.5)
    }
    if (!is.null(o.genes)) 
        text(rs[o.genes], ms[o.genes], label = which(attr(ratios, 
            "rnames") %in% o.genes), col = "green", cex = 0.5)
    rr <- get.density.scores(ks = k, plot = T)$r
    rr <- as.vector(rr)
    names(rr) <- attr(ratios, "rnames")
    h <- try(hist(log10(rr), breaks = 50, main = NULL, xlab = "Density (membership) scores"))
    if (class(h) != "try-error") {
        try(hist(rep(log10(rr[rows]), tmp.scale), breaks = h$breaks, 
            col = "red", border = "red", add = T))
        try(hist(log10(rr), breaks = h$breaks, add = T))
    }
    par(opar)
}
plot.stats <-
function (iter = stats$iter[nrow(stats)], plot.clust = NA, new.dev = T) 
{
    row.memb <- t(apply(row.membership, 1, function(i) 1:k.clust %in% 
        i))
    opar <- par(no.readonly = T)
    tmp.scale <- round(1/mean(row.memb, na.rm = T)/4)
    if (new.dev) {
        if (length(dev.list()) < 1) 
            dev.new()
        dev.set(2)
    }
    layout(matrix(c(1, 2, 3, 1, 2, 3, 4, 5, 6, 4, 5, 6, 7, 8, 
        9, 7, 8, 10), byrow = T, ncol = 3))
    par(mar = c(3, 3, 2, 0.1), mgp = c(3, 1, 0) * 0.5)
    stats <- stats[stats[, "iter"] <= iter, , drop = F]
    try(matplot(stats[, "iter"], stats[, grep("resid", colnames(stats), 
        val = T)], typ = "l", xlab = "iter", ylab = "Mean resid", 
        main = sprintf("Iter: %d", iter)), silent = T)
    if ((nn <- length(grep("resid", colnames(stats)))) > 1) 
        legend("bottomleft", legend = gsub("resid.", "", grep("resid", 
            colnames(stats), val = T)), lwd = 1, bty = "n", col = 1:nn, 
            lty = 1:nn, cex = 0.5)
    try(matplot(stats[, "iter", drop = F], stats[, c("nrow", 
        "ncol"), drop = F], typ = "l", xlab = "iter", ylab = "Mean nrow, ncol"), 
        silent = T)
    rs <- row.scores[]
    rs[rs < -220] <- min(rs[rs > -220], na.rm = T)
    h <- try(hist(rs, breaks = 50, main = NULL, xlab = "Ratios scores"))
    if (class(h) != "try-error") {
        try(hist(rep(rs[row.memb], tmp.scale), breaks = h$breaks, 
            col = "red", border = "red", add = T), silent = T)
        try(hist(rs, breaks = h$breaks, add = T), silent = T)
    }
    if (!is.null(mot.scores)) {
        ms <- mot.scores[]
        ms[ms < -20] <- min(ms[ms > -20], na.rm = T)
        ms[ms >= 0] <- NA
        h <- try(hist(ms, breaks = 50, main = NULL, xlab = "Motif scores"))
        if (class(h) != "try-error") {
            try(hist(rep(ms[row.memb], tmp.scale * 3), breaks = h$breaks, 
                col = "red", border = "red", add = T), silent = T)
            try(hist(ms, breaks = h$breaks, add = T), silent = T)
        }
        try(matplot(stats[, "iter"], stats[, grep("p.clust", 
            colnames(stats), val = T)], typ = "l", xlab = "iter", 
            ylab = "Mean motif p-value", main = sprintf("Motif scaling: %.3f", 
                mot.scaling[max(1, iter - 1)])), silent = T)
        if ((nn <- length(grep("p.clust", colnames(stats)))) > 
            1) 
            legend("bottomleft", legend = gsub("p.clust.", "", 
                grep("p.clust", colnames(stats), val = T)), lwd = 1, 
                bty = "n", col = 1:nn, lty = 1:nn, cex = 0.5)
    }
    if (!is.null(net.scores)) {
        ns <- net.scores[]
        ns[ns < -20] <- min(ns[ns > -20], na.rm = T)
        ns[ns >= 0] <- NA
        ns <- -log10(-ns)
        tmp.scale <- ceiling(tmp.scale * mean(!is.na(ns), na.rm = T))
        h <- try(hist(ns, breaks = 50, main = NULL, xlab = "-log10(-Network scores)"), 
            silent = T)
        if (class(h) != "try-error") {
            try(hist(rep(ns[row.memb], tmp.scale), breaks = h$breaks, 
                col = "red", border = "red", add = T), silent = T)
            try(hist(ns, breaks = h$breaks, add = T))
        }
        try(matplot(stats[, "iter"], stats[, grep("net.", colnames(stats), 
            val = T, fixed = T)], typ = "l", xlab = "iter", ylab = "Mean net-score", 
            main = sprintf("Net scaling: %.3f", net.scaling[max(1, 
                iter - 1)])), silent = T)
        if ((nn <- length(grep("net.", colnames(stats)))) > 1) 
            try(legend("bottomleft", legend = gsub("net.", "", 
                grep("net.", colnames(stats), val = T)), lwd = 1, 
                bty = "n", col = 1:nn, lty = 1:nn, cex = 0.5), 
                silent = T)
    }
    clusterStack <- get.clusterStack(ks = 1:k.clust)
    resids <- sapply(clusterStack, "[[", "resid")
    try(hist(resids[resids <= 1.5], main = NULL, xlab = "Cluster Residuals", 
        xlim = c(0, 1.5), breaks = k.clust/4), silent = T)
    n.rows <- tabulate(unlist(apply(row.membership, 1, unique)))
    try(hist(n.rows, main = NULL, xlab = "Cluster Nrows", breaks = k.clust/4, 
        xlim = c(-5, max(n.rows, na.rm = T))), silent = T)
    n.cols <- tabulate(unlist(apply(col.membership, 1, unique)))
    try(hist(n.cols, main = NULL, xlab = "Cluster Ncols", breaks = k.clust/4, 
        xlim = c(-5, max(n.cols, na.rm = T))), silent = T)
    if (!is.na(plot.clust)) {
        if (new.dev) {
            if (length(dev.list()) < 2) 
                dev.new()
            dev.set(3)
        }
        try(plotClust(plot.clust, T, cex = 0.7), silent = T)
        if (new.dev) {
            if (length(dev.list()) < 3) 
                dev.new()
            dev.set(4)
        }
        try(plot.scores(plot.clust), silent = T)
    }
    par(opar)
}
plotClust <-
function (k, w.motifs = T, all.conds = F, title = NULL, o.genes = NULL, 
    dont.plot = F, network = "all", short.names = organism == 
        "sce", seq.type = names(mot.weights), ...) 
{
    if (!dont.plot) 
        opar <- par(no.readonly = T)
    c <- get.clust(k)
    rows <- get.rows(k)
    if (!is.null(o.genes)) 
        rows <- c(rows, o.genes)
    if (!w.motifs && !dont.plot) {
        if (all.conds) 
            plotCluster.all.conds(c, o.genes = o.genes, ...)
        else plotCluster(c, o.genes = o.genes, ...)
    }
    else {
        c$seq.type <- seq.type
        for (st in seq.type) {
            c[[st]] <- list()
            c[[st]]$motif.out <- meme.scores[[st]][[k]]
            tmp <- cluster.pclust(k, st)
            c[[st]]$e.val <- tmp$e.vals
            c[[st]]$p.clust <- tmp$p.clusts
            c[[st]]$motif.out$pssms <- lapply(c[[st]]$motif.out$meme.out, 
                "[[", "pssm")
            c[[st]]$motif.out$e.values <- c[[st]]$e.val
            if (!is.null(c[[st]]$motif.out$pv.ev)) {
                c[[st]]$motif.out$pv.ev[[2]] <- c[[st]]$motif.out$pv.ev[[1]]
                c[[st]]$motif.out$pv.ev[[1]] <- cbind(p.value = meme.scores[[st]]$all.pv[, 
                  k], e.value = if (!is.null(meme.scores[[st]]$all.ev)) 
                  meme.scores[[st]]$all.ev[, k]
                else NA)
                c[[st]]$motif.out$p.values <- log10(c[[st]]$motif.out$pv.ev[[1]][, 
                  "p.value"])
                names(c[[st]]$motif.out$p.values) <- rownames(c[[st]]$motif.out$pv.ev[[1]])
            }
        }
    }
    if (!is.na(mot.iters[1])) {
        c$seqs <- get.sequences(rows, distance = motif.upstream.scan[[seq.type[1]]], 
            seq.type = seq.type[1])[rows]
        if (!is.null(c$seqs)) 
            names(c$seqs) <- rows
    }
    else c$seqs <- NULL
    if (!is.na(net.iters[1])) {
        if (network == "all") 
            network <- names(networks)
        for (i in network) {
            if (!i %in% names(networks)) 
                next
            tmp.net <- networks[[i]][networks[[i]]$protein1 %in% 
                rows & networks[[i]]$protein2 %in% rows, ]
            tmp.net <- cbind(tmp.net, net = rep(i, nrow(tmp.net)))
            c$network <- if (!is.null(c$network)) 
                rbind(c$network, tmp.net)
            else tmp.net
        }
    }
    c$gene.coords <- get.long.names(rows, short = short.names)
    if (!is.null(genome.info$cog.code)) 
        c$cog.code <- genome.info$cog.code[rows]
    if (!is.null(title)) 
        c$name <- title
    if (!dont.plot) {
        plotCluster.motif(c, seqs = c$seqs, p.val.shade.cutoff = 1, 
            o.genes = o.genes, ...)
        par(opar)
    }
    invisible(c)
}
plotCluster <-
function (cluster, imag = F, cond.labels = F, o.genes = NULL, 
    col.func = if (imag) topo.colors else rainbow, rats.names = names(ratios), 
    main = NULL, no.par = F, sort = F, box.plot = F, ...) 
{
    k <- cluster$k
    if (is.null(main)) 
        main <- paste(sprintf("Cluster: %03d %s; resid: %s; r/c: %d/%d", 
            k, organism, paste(sprintf("%.2f", cluster$resid[rats.names]), 
                collapse = " "), length(cluster$rows), length(cluster$cols)))
    rats <- get.cluster.matrix(unique(c(cluster$rows, o.genes)), 
        cluster$cols, matrices = rats.names)
    cols.b <- colnames(rats)
    if (sort) {
        o1 <- order(apply(rats[cluster$rows, cols.b], 2, mean, 
            na.rm = T))
        cols.b <- cols.b[o1]
        rats <- rats[, cols.b]
    }
    if (all(is.na(rats))) {
        plot(0, 0, typ = "n", min = main, ...)
        return()
    }
    if (is.vector(rats)) {
        rats <- t(rats)
        rownames(rats) <- cluster$rows
    }
    if (imag) {
        grey.image <- function(mat, n.gray = 32, x = 1:nrow(mat), 
            y = 1:ncol(mat), col = gray((0:n.gray)/n.gray), ...) image(x, 
            y, mat, col = col, ...)
        grey.image(t(rats), col = col.func(256))
        return()
    }
    range.r <- range(rats, na.rm = T)
    if (cond.labels && cluster$ncols < 100) 
        range.r[1] <- range.r[1] * 1.5
    if (!no.par) 
        par(mar = rep(2, 4), mgp = c(3, 1, 0) * 0.5)
    plot(1:length(cols.b), ylim = range.r, xlab = NA, ylab = NA, 
        main = main, typ = "n")
    if (length(rats.names) > 1) {
        ind <- 0.5
        rts <- NULL
        for (i in 1:length(rats.names)) {
            col <- sapply(col2rgb(i + 1)/255 + 0.9, function(cc) min(cc, 
                1))
            col <- rgb(col[1], col[2], col[3])
            rect(ind, range.r[1] + 0.05, ind + sum(colnames(rats) %in% 
                colnames(ratios[[rats.names[i]]])), range.r[2] - 
                0.05, col = col, dens = NA)
            ind <- ind + sum(colnames(rats) %in% colnames(ratios[[rats.names[i]]]))
            rts <- cbind(rts, rats[, cols.b[cols.b %in% colnames(ratios[[rats.names[i]]])]])
        }
        rats <- rts
        rm(rts)
        cols.b <- colnames(rats)
    }
    if (box.plot) {
        if (all(deparse(col.func) == deparse(rainbow))) 
            colmap <- col.func(length(cols.b))
        else colmap <- col.func(cols.b)
        boxplot(as.data.frame(rats[cluster$rows, ]), ylim = range.r, 
            names = NA, main = main, col = colmap, border = FALSE, 
            add = T, ...)
        colMeans <- apply(rats[cluster$rows, ], 2, mean, na.rm = T)
        lines(1:length(cols.b), colMeans, lty = 1, lwd = 1, col = "red")
        colSd <- 2 * apply(rats[cluster$rows, ], 2, sd, na.rm = T)
        matlines(1:length(cols.b), cbind(colMeans - colSd, colMeans + 
            colSd), lty = 1, col = "grey")
    }
    else {
        colmap <- col.func(cluster$nrow)
        matlines(1:length(cols.b), t(rats[cluster$rows, ]), ylim = range.r, 
            xlab = NA, ylab = NA, main = main, col = colmap, 
            lty = 1, ...)
    }
    if (cond.labels) {
        tmp.y <- rep(range.r[1] * 0.85, cluster$ncols)
        cols <- if (box.plot) 
            colmap
        else "black"
        text(1:cluster$ncols, tmp.y, cols.b, srt = 90, col = cols, 
            ...)
    }
    if (names(dev.cur()) == "devSVG") {
        par(family = "Arial")
        for (c in 1:length(cols.b)) {
            setSVGShapeToolTip(cols.b[c])
            rect(c, range.r[1], c + 1, range.r[2], col = NA, 
                border = NA)
        }
    }
    if (!is.null(o.genes)) {
        matlines(1:length(cols.b), t(rats[o.genes, , drop = F]), 
            lty = 1, lwd = 3, col = 2:6)
        legend("bottomright", legend = o.genes, lty = 1, lwd = 3, 
            col = 2:6, cex = 0.7, bty = "n")
    }
}
plotCluster.all.conds <-
function (cluster, imag = F, cond.labels = F, o.genes = NULL, 
    rats.names = names(ratios), sort = F, box.plot = F, col.func = if (imag) topo.colors else rainbow, 
    ...) 
{
    k <- cluster$k
    main <- paste(sprintf("Cluster: %03d %s; resid: %s; r/c: %d/%d", 
        k, organism, paste(sprintf("%.2f", cluster$resid[rats.names]), 
            collapse = " "), length(cluster$rows), length(cluster$cols)))
    rats <- get.cluster.matrix(unique(c(cluster$rows, o.genes)), 
        NULL, matrices = rats.names)
    cols.b <- colnames(rats)
    if (sort) {
        inClust <- colnames(rats)[colnames(rats) %in% cluster$cols]
        o1 <- order(apply(rats[cluster$rows, inClust], 2, mean, 
            na.rm = T))
        outClust <- colnames(rats)[!colnames(rats) %in% cluster$cols]
        o2 <- order(apply(rats[cluster$rows, outClust], 2, mean, 
            na.rm = T))
        cols.b <- c(inClust[o1], outClust[o2])
        rats <- rats[, cols.b]
    }
    len.b <- length(cols.b)
    par(mar = rep(2, 4), mgp = c(3, 1, 0) * 0.5)
    if (all(is.na(rats))) {
        plot(0, 0, typ = "n", main = main, ...)
        return()
    }
    if (is.vector(rats)) {
        rats <- t(rats)
        rownames(rats) <- cluster$rows
    }
    if (imag) {
        grey.image(t(rats), col = col.func(256))
        lines(rep(cluster$ncols + 0.5, 2), c(-999, 9999), col = 2, 
            lwd = 3, lty = 2)
        return()
    }
    range.r <- range(rats, na.rm = T)
    if (cond.labels && len.b < 100) 
        range.r[1] <- range.r[1] * 1.5
    plot(1:len.b, xlim = c(0.95, len.b + 0.05), ylim = range.r, 
        xlab = NA, ylab = NA, main = main, typ = "n")
    if (length(ratios) > 1) {
        ind <- 0.5
        rts.in <- rts.out <- NULL
        for (in.out in 1:2) {
            if (in.out == 1) 
                cols <- cols.b[cols.b %in% cluster$cols]
            else if (in.out == 2) 
                cols <- cols.b[!cols.b %in% cluster$cols]
            for (i in 1:length(ratios)) {
                col <- sapply(col2rgb(i + 1)/255 + 0.9, function(cc) min(cc, 
                  1))
                col <- rgb(col[1], col[2], col[3])
                rect(ind, range.r[1] + 0.01, ind + sum(cols %in% 
                  colnames(ratios[[i]])), range.r[2] - 0.01, 
                  col = col, dens = NA)
                ind <- ind + sum(cols %in% colnames(ratios[[i]]))
                if (in.out == 1) 
                  rts.in <- cbind(rts.in, rats[, cols[cols %in% 
                    colnames(ratios[[i]])]])
                else if (in.out == 2) 
                  rts.out <- cbind(rts.out, rats[, cols[cols %in% 
                    colnames(ratios[[i]])]])
            }
        }
        rats <- cbind(rts.in, rts.out)
        cols.b <- colnames(rats)
        rm(rts.in, rts.out)
    }
    if (box.plot) {
        if (all(deparse(col.func) == deparse(rainbow))) 
            colmap <- col.func(len.b)
        else colmap <- col.func(cols.b)
        boxplot(as.data.frame(rats[cluster$rows, ]), ylim = range.r, 
            names = NA, main = main, col = colmap, border = FALSE, 
            add = T, ...)
        colMeans <- apply(rats[cluster$rows, ], 2, mean, na.rm = T)
        lines(1:length(cols.b), colMeans, lty = 1, lwd = 1, col = "red")
        colSd <- 2 * apply(rats[cluster$rows, ], 2, sd, na.rm = T)
        matlines(1:length(cols.b), cbind(colMeans - colSd, colMeans + 
            colSd), lty = 1, col = "grey")
    }
    else {
        colmap <- col.func(cluster$nrow)
        matlines(1:len.b, t(rats[cluster$rows, ]), ylim = range.r, 
            col = colmap, main = main, xlab = NA, ylab = NA, 
            lty = 1, ...)
    }
    cols.in <- colnames(rats)[colnames(rats) %in% cluster$cols]
    lines(rep(length(cols.in) + 0.5, 2), range.r, col = 2, lwd = 3, 
        lty = 2)
    if (!is.null(o.genes)) {
        matlines(1:len.b, t(rats[o.genes, , drop = F]), lty = 1, 
            lwd = 3, col = 2:6)
        legend("bottomright", legend = o.genes, lty = 1, lwd = 3, 
            col = 2:6, cex = 0.7, bty = "n")
    }
    if (cond.labels) {
        tmp.y <- rep(range.r[1] * 0.85, len.b)
        cols <- if (box.plot) 
            colmap
        else "black"
        text(1:len.b, tmp.y, cols.b, srt = 90, col = cols, ...)
    }
    if (names(dev.cur()) == "devSVG") {
        par(family = "Arial")
        for (c in 1:length(cols.b)) {
            setSVGShapeToolTip(cols.b[c])
            rect(c, range.r[1], c + 1, range.r[2], col = NA, 
                border = NA)
        }
    }
}
plotCluster.motif <-
function (cluster, seqs = cluster$seqs, layout = NULL, colors = NULL, 
    main = NULL, ...) 
{
    if (names(dev.cur()) == "devSVG") 
        par(family = "Arial")
    if (any(!cluster$rows %in% attr(ratios, "rnames"))) {
        cluster$rows <- cluster$rows[cluster$rows %in% attr(ratios, 
            "rnames")]
        cluster$nrow <- length(cluster$rows)
        warning(cluster$k, ": Some cluster rows are not in the ratios. Will plot without these rows.\n")
    }
    if (any(!cluster$cols %in% attr(ratios, "cnames"))) {
        cluster$cols <- cluster$cols[cluster$cols %in% attr(ratios, 
            "cnames")]
        cluster$ncol <- length(cluster$cols)
        warning(cluster$k, ": Some cluster cols are not in the ratios. Will plot without these cols.\n")
    }
    seq.types <- cluster$seq.type
    if (is.null(layout)) {
        if (length(seq.types) == 1) {
            layout(matrix(c(1, 1, 1, 1, 1, 1, 1, 1, 8, 2, 2, 
                2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 8, 
                2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 
                4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 6, 
                6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7), ncol = 17, 
                byrow = T))
        }
        else {
            layout(matrix(c(1, 1, 1, 1, 1, 1, 1, 1, 11, 2, 2, 
                2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 11, 
                2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 
                1, 11, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 
                1, 1, 1, 11, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 
                3, 5, 5, 5, 5, 10, 10, 10, 10, 10, 10, 10, 10, 
                10, 4, 4, 4, 4, 6, 6, 6, 6, 10, 10, 10, 10, 10, 
                10, 10, 10, 10, 7, 7, 7, 7, 9, 9, 9, 9, 10, 10, 
                10, 10, 10, 10, 10, 10, 10, 8, 8, 8, 8, 9, 9, 
                9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10), ncol = 17, 
                byrow = T))
        }
    }
    k <- cluster$k
    if (!is.null(ratios)) {
        plotCluster.all.conds(cluster, ...)
        plotCluster(cluster, ...)
    }
    rows <- cluster$rows
    if (is.null(colors) && exists("gene.coords") || !is.null(cluster$cog.code)) {
        tmp.lett <- 1:26
        names(tmp.lett) <- LETTERS
        if (exists("gene.coords") && !is.null(gene.coords$gene.code)) 
            coo <- gene.coords$gene.code[rows]
        else if (!is.null(cluster$cog.code)) 
            coo <- cluster$cog.code[rows]
        else coo <- 1:length(rows)
        tmp <- unique(tmp.lett[coo])
        names(tmp) <- names(tmp.lett[coo][!duplicated(tmp.lett[coo])])
        cols <- rainbow(length(tmp))
        names(cols) <- names(tmp)
        cols <- cols[names(tmp.lett[coo])]
        cols[is.na(names(cols))] <- "darkgrey"
        names(cols) <- rows
    }
    else {
        cols <- rainbow(length(rows))
        names(cols) <- rows
    }
    colors <- cols
    if (length(seq.types) > 1) 
        seq.types <- seq.types[1:3]
    for (seq.type in seq.types) {
        if (is.na(seq.type) || is.null(cluster[[seq.type]]$e.val) || 
            all(is.na(cluster[[seq.type]]$e.val)) || is.null(cluster[[seq.type]]$motif.out) || 
            all(is.na(cluster[[seq.type]]$p.clust)) || is.null(cluster[[seq.type]]$motif.out$pssms)) {
            for (i in 1:2) plot(1, 1, typ = "n", axes = F, xaxt = "n", 
                yaxt = "n", xlab = "", ylab = "")
        }
        else {
            pssm <- cluster[[seq.type]]$motif.out$pssms
            for (ppp in 1:length(pssm)) {
                viewPssm(pssm[[ppp]], mot.ind = ppp, main.title = c(seq.type, 
                  paste("PSSM #", ppp, "; E=", cluster[[seq.type]]$motif.out$e.values[ppp], 
                    sep = "")), cex.main = 0.9)
            }
            if (length(pssm) < 2) 
                for (i in (length(pssm) + 1):2) plot(1, 1, typ = "n", 
                  axes = F, xaxt = "n", yaxt = "n", xlab = "", 
                  ylab = "")
        }
        if (length(seq.types) == 1) 
            plot(1, 1, typ = "n", axes = F, xaxt = "n", yaxt = "n", 
                xlab = "", ylab = "")
    }
    plotCluster.network(cluster, ...)
    if (is.null(seqs)) {
        seqs <- rep("", length(cluster$rows))
        names(seqs) <- cluster$rows
    }
    if (!is.null(seqs) && length(seqs) > 0) 
        plotClusterMotifPositions(cluster, seqs, colors = colors, 
            ...)
    else plot(1, 1, typ = "n", axes = F, xaxt = "n", yaxt = "n", 
        xlab = "", ylab = "")
    try({
        par(mar = rep(0.5, 4), mgp = c(2, 1, 0) * 0.5)
        plot(c(0.5, 2.5), c(-1, 1), type = "n", tck = 0.01, cex.lab = 0.2, 
            cex.sub = 0.2, cex.axis = 0.2, axes = F)
        if (names(dev.cur()) == "devSVG") {
            par(family = "Arial")
            setSVGShapeToolTip(title = paste("Cluster:", sprintf("%03d", 
                k), organism, cmonkey.version), desc1 = sprintf("resid = %s; genes = %d; conds = %d", 
                paste(sprintf("%.2f", cluster$resid), collapse = " "), 
                length(cluster$rows), length(cluster$cols)))
            setSVGShapeURL(paste("http://www.genome.ad.jp/dbget-bin/www_bget?", 
                paste(organism, ":", cluster$rows, sep = "", 
                  collapse = "+"), sep = ""))
            rect(0.5, -1, 3.25, +1, col = "lightgreen", border = NA)
        }
    })
    if (names(dev.cur()) != "devSVG") {
        if (!is.null(cluster$name)) 
            text(0, 0, cluster$name, srt = 90, xpd = NA, cex = 1)
        text(1, 0, date.run, srt = 90, xpd = NA, cex = 1)
        text(2, 0, paste("cMonkey Version", cmonkey.version, 
            organism), srt = 90, xpd = NA, cex = 1)
    }
}
plotCluster.network <-
function (cluster, network = "all", o.genes = NULL, colors = NULL, 
    cex = 0.7, no.legend = F, ...) 
{
    require(igraph)
    rows <- cluster$rows
    if (is.null(cluster$network)) {
        if (network == "all") 
            network <- names(networks)
        for (i in network) {
            if (!i %in% names(networks)) 
                next
            tmp.net <- networks[[i]][networks[[i]]$protein1 %in% 
                rows & networks[[i]]$protein2 %in% rows, ]
            tmp.net <- cbind(tmp.net, net = rep(i, nrow(tmp.net)))
            cluster$network <- if (!is.null(cluster$network)) 
                rbind(cluster$network, tmp.net)
            else tmp.net
        }
    }
    network <- cluster$network
    nrows <- rows
    if (!is.null(o.genes)) 
        nrows <- c(nrows, o.genes)
    if (is.null(cluster$cog.code) && !is.null(genome.info$cog.code)) 
        cluster$cog.code <- genome.info$cog.code[rows]
    if (is.null(cluster$colors)) {
        if (is.null(colors) && exists("gene.coords") || !is.null(cluster$cog.code)) {
            tmp.lett <- 1:26
            names(tmp.lett) <- LETTERS
            if (exists("gene.coords") && !is.vector(gene.coords) && 
                !is.null(gene.coords$gene.code)) 
                coo <- gene.coords$gene.code[rows]
            else if (!is.null(cluster$cog.code)) 
                coo <- cluster$cog.code[rows]
            else coo <- 1:length(rows)
            tmp <- unique(tmp.lett[coo])
            names(tmp) <- names(tmp.lett[coo][!duplicated(tmp.lett[coo])])
            cols <- rainbow(length(tmp))
            names(cols) <- names(tmp)
            cols <- cols[names(tmp.lett[coo])]
            cols[is.na(names(cols))] <- "darkgrey"
            names(cols) <- rows
            cluster$colors <- cols
        }
        else {
            cols <- rainbow(length(rows))
            names(cols) <- rows
            cluster$colors <- cols
        }
    }
    colors <- cluster$colors
    if (is.null(network) || nrow(network) <= 0) 
        network <- data.frame(protein1 = nrows, protein2 = nrows, 
            combined_score = jitter(rep(1/50, length(nrows))), 
            net = rep("none", length(nrows)))
    not.in <- nrows[!nrows %in% network$protein1 & !nrows %in% 
        network$protein2]
    for (i in not.in) network <- rbind(network, data.frame(protein1 = i, 
        protein2 = i, combined_score = 0, net = "none"))
    gr <- graph.edgelist(as.matrix(network[, 1:2]), directed = F)
    net.wts <- as.numeric(network$combined_score)
    names(net.wts) <- as.character(network$net)
    for (n in unique(names(net.wts))) {
        if (n == "none") 
            next
        net.wts[names(net.wts) == n] <- net.wts[names(net.wts) == 
            n]/max(net.wts[names(net.wts) == n], na.rm = T)
    }
    gr.layout <- layout.fruchterman.reingold(gr, niter = 3000, 
        weights = net.wts/5)
    gr.layout <- layout.norm(gr.layout, -1, 1, -1, 1)
    edge.colors <- character()
    curves <- rep(0, nrow(network))
    nets <- unique(as.character(network$net))
    if ("none" %in% nets) {
        nets <- unique(c("none", nets))
        inds <- c(1, 1:(length(nets) - 1))
        inds <- inds[inds != 0]
        inds <- inds[1:length(nets)]
        net.colors <- t(col2rgb(inds, T))/255
        net.colors[1, 4] <- 0
    }
    else {
        net.colors <- t(col2rgb(1:length(nets), T))/255
    }
    rownames(net.colors) <- nets
    for (i in 1:nrow(network)) {
        net <- as.character(network$net)[i]
        shade <- net.wts[i]
        nodes <- c(as.character(network$protein1)[i], as.character(network$protein2)[i])
        sub.net <- subset(network, protein1 %in% nodes & protein2 %in% 
            nodes)
        sub.nets <- unique(as.character(sub.net$net))
        curve.it <- max(0, nrow(sub.net) - 2)/2 * 0.33
        col <- net.colors[net, ]
        col2 <- col
        col2[col2 == 0] <- 1 - shade
        edge.colors[i] <- if (names(dev.cur()) != "X11") 
            rgb(col[1], col[2], col[3], shade)
        else rgb(col2[1], col2[2], col2[3])
        curves[i] <- curve.it * floor(which(sub.nets == net)/2) * 
            (if (which(sub.nets == net)%%2 == 0) 
                -1
            else 1)
    }
    if (all(curves == 0)) 
        curves <- FALSE
    if (!no.legend) {
        labels <- try(get.long.names(get.vertex.attribute(gr, 
            "name"), short = T))
        if (class(labels) == "try-error") 
            labels <- get.vertex.attribute(gr, "name")
        labels[is.na(labels) | labels == ""] <- get.vertex.attribute(gr, 
            "name")[is.na(labels) | labels == ""]
    }
    else labels <- NA
    plot(gr, layout = gr.layout, margin = 0, rescale = F, edge.curved = curves, 
        vertex.color = colors[get.vertex.attribute(gr, "name")], 
        vertex.frame.color = colors[get.vertex.attribute(gr, 
            "name")], vertex.label.cex = cex, vertex.size = 7, 
        vertex.label = labels, vertex.label.family = if (names(dev.cur()) != 
            "pdf") 
            "Arial"
        else "sans", edge.color = edge.colors, edge.width = round(net.wts) + 
            1)
    if (!no.legend && length(nets[nets != "none"]) > 0) 
        legend("bottomright", legend = nets[nets != "none"], 
            col = 1:length(nets[nets != "none"]), lty = 1, lwd = 2, 
            bty = "n", cex = 0.5)
    if (names(dev.cur()) == "devSVG") {
        names <- cluster$gene.coords
        for (i in 1:nrow(gr.layout)) {
            gene <- get.vertex.attribute(gr, "name")[i]
            setSVGShapeToolTip(title = gene, desc1 = ifelse(is.na(names[gene]), 
                "", names[gene]))
            setSVGShapeURL(paste("http://www.genome.ad.jp/dbget-bin/www_bget?", 
                organism, ":", gene, sep = ""))
            points(gr.layout[i, 1], gr.layout[i, 2], col = "#FF000001", 
                cex = 10/3)
        }
    }
}
plotClusterMotifPositions <-
function (cluster, seqs = cluster$seqs, long.names = T, shade = T, 
    p.val.shade.cutoff = 999, colors = NULL, no.plot = F, sort.by = "p.value", 
    o.genes = NULL, no.key = F, short.names = organism == "sce", 
    seq.type = cluster$seq.type[1], ...) 
{
    k <- cluster$k
    rows <- cluster$rows
    if (!is.null(o.genes)) 
        rows <- c(rows, o.genes)
    motif.out <- cluster[[seq.type]]$motif.out
    is.dup.seq <- get.dup.seqs(cluster$seqs)
    p.clust <- cluster$p.clust
    motif.info <- NULL
    if (!is.na(p.clust)) 
        motif.info <- subset(motif.out$pv.ev[[2]], gene %in% 
            rows)
    if (no.plot) {
        out.posns <- list()
        out.posns$starts <- out.posns$ends <- out.posns$mots <- integer()
        out.posns$p.vals <- out.posns$e.vals <- numeric()
    }
    if (!exists("gene.coords")) 
        gene.coords <- cluster$gene.coords
    if (is.null(colors) && exists("gene.coords") || !is.null(cluster$cog.code)) {
        tmp.lett <- 1:26
        names(tmp.lett) <- LETTERS
        if (exists("gene.coords") && !is.vector(gene.coords) && 
            !is.null(gene.coords$gene.code)) 
            coo <- gene.coords$gene.code[rows]
        else if (!is.null(cluster$cog.code)) 
            coo <- cluster$cog.code[rows]
        else coo <- 1:length(rows)
        tmp <- unique(tmp.lett[coo])
        names(tmp) <- names(tmp.lett[coo][!duplicated(tmp.lett[coo])])
        cols <- rainbow(length(tmp))
        names(cols) <- names(tmp)
        cols <- cols[names(tmp.lett[coo])]
        cols[is.na(names(cols))] <- "darkgrey"
        names(cols) <- rows
    }
    else {
        cols <- rainbow(length(rows))
        names(cols) <- rows
    }
    cluster$colors <- colors <- cols
    no.motif <- FALSE
    p.values <- motif.widths <- pssm <- NULL
    if (!is.null(motif.out) && nrow(motif.info) > 0 && !is.na(p.clust)) {
        p.values <- motif.out$p.values[rows]
        motif.widths <- sapply(motif.out$pssms, nrow, simplify = T)
        pssm <- motif.out$pssms
    }
    else {
        no.motif <- TRUE
        p.values <- numeric(length(rows))
        motif.widths <- 0
    }
    seqs <- seqs[rows]
    names(seqs) <- names(p.values) <- rows
    seq.lengths <- nchar(seqs)
    seq.lengths[seq.lengths == 2] <- NA
    if (any(seq.lengths[!is.na(seq.lengths)] > median(seq.lengths, 
        na.rm = T))) {
        seqs <- substr(seqs, 1, median(seq.lengths, na.rm = T))
        seq.lengths <- nchar(seqs)
    }
    maxlen <- max(seq.lengths, na.rm = T)
    if (maxlen == 0) 
        maxlen <- diff(motif.upstream.search[[seq.type]])
    inds <- integer()
    if (no.motif && (sort.by == "p.value" || sort.by == TRUE)) 
        sort.by <- "gene.name"
    if (sort.by == "gene.name") 
        inds <- sort(rows, decreasing = T, index = T)$ix
    else if (sort.by == "p.value" || sort.by == TRUE) 
        inds <- order(p.values[rows], decreasing = T, na.last = F)
    else if (sort.by == "resid") 
        inds <- order(row.scores[rows, k], decreasing = T)
    else if (sort.by == "total") 
        inds <- order(rr.scores[rows, k], decreasing = T)
    if (length(inds) < length(rows)) 
        inds <- c((1:length(rows))[!1:length(rows) %in% inds], 
            inds)
    x.range <- c(-maxlen * 0.08, maxlen * 1.15)
    y.range <- c(0.5, length(rows) + 1)
    if (!no.plot) {
        plot(x.range, y.range, type = "n", axes = F, xlab = "sequence position", 
            ylab = "")
        cexes <- 1
        if (!no.key) 
            axis(side = 1, pos = 0.6, tck = 0.01, mgp = c(0.1, 
                0.1, 0.1), labels = c(-1, seq(-100, -maxlen, 
                -100)), at = seq(maxlen, 0, -100) + motif.upstream.scan[[seq.type]][1], 
                ...)
        if (max(seq.lengths, na.rm = T) > 0) 
            sapply(maxlen - c(0, motif.upstream.search[[seq.type]]) + 
                motif.upstream.scan[[seq.type]][1], function(i) lines(rep(i, 
                2), c(-999, 999), col = "lightgray", lty = 2))
        colmap <- rainbow(length(rows))
    }
    mots.used <- numeric()
    if (is.list(motif.widths)) {
        if (length(motif.widths) <= 0) 
            motif.widths <- 0
        else {
            for (i in 1:length(motif.widths)) if (is.null(motif.widths[[i]])) 
                motif.widths[[i]] <- 0
            motif.widths <- unlist(motif.widths)
        }
    }
    lwd <- 3
    if (length(rows) > 20) 
        lwd <- 1
    else if (length(rows) > 10) 
        lwd <- 2
    if (no.key) 
        lwd <- 1
    if (!no.motif) {
        tmp.mot.info <- subset(motif.info, gene %in% rows)
        tmp.mot.info <- subset(tmp.mot.info, posns <= diff(motif.upstream.scan[[seq.type]]))
        p.min <- quantile(log10(tmp.mot.info$pvals), 0.1, na.rm = T)
        if (is.na(p.min)) 
            p.min <- -5
        p.max <- quantile(log10(tmp.mot.info$pvals), na.rm = T, 
            0.9)
        if (is.na(p.max)) 
            p.max <- log10(p.val.shade.cutoff)
    }
    for (j in 1:length(rows)) {
        jj <- inds[j]
        cur.gene <- rows[jj]
        seq.len <- seq.lengths[jj]
        if (!is.null(rows)) {
            label <- rows[jj]
            if (!is.null(colors)) 
                rect(maxlen + 5, j - 0.18, maxlen * 1.195, j + 
                  0.18, col = colors[label], border = colors[label], 
                  lwd = 3)
        }
        if (!no.motif) {
            rects <- NULL
            mot.info <- subset(tmp.mot.info, gene == cur.gene)
            if (nrow(mot.info) > 0) {
                mots <- mot.info$mots
                starts <- mot.info$posns
                widths <- motif.widths[abs(mots)]
                for (i in 1:length(mots)) {
                  mot <- mots[i]
                  if (is.na(mot)) 
                    next
                  start <- starts[i]
                  if (start > seq.len) 
                    next
                  end <- start + widths[i]
                  if (no.plot) {
                    out.posns$starts <- c(out.posns$starts, start)
                    out.posns$ends <- c(out.posns$ends, end)
                    out.posns$mots <- c(out.posns$mots, abs(mot))
                    out.posns$p.vals <- c(out.posns$p.vals, mot.info$pvals[i])
                    out.posns$e.vals <- c(out.posns$e.vals, motif.out$e.values[abs(mot)])
                    next
                  }
                  mots.used <- c(mots.used, abs(mot))
                  col <- abs(mot) + 1
                  if (shade) {
                    if (!is.null(mot.info)) 
                      p.val <- mot.info$pvals[i]
                    else p.val <- 1e-05
                    if (is.na(p.val) || p.val > p.val.shade.cutoff || 
                      p.val > 1) 
                      next
                    else if (p.val <= 0) 
                      p.val <- 1e-05
                    p.val <- log10(p.val)
                    col <- col2rgb(palette()[col])/255
                    col[col > 0] <- 1
                    tmp <- if (p.val < 10) 
                      min(1, max(0, (p.val - p.min)/(p.max - 
                        p.min)))
                    else 0.99
                    if (names(dev.cur()) != "X11") {
                      alpha <- tmp
                    }
                    else {
                      col[col == 0] <- tmp
                      alpha <- 0
                    }
                    col[col < 0] <- 0
                    col[col > 1] <- 1
                    col <- rgb(col["red", 1], col["green", 1], 
                      col["blue", 1], 1 - alpha)
                  }
                  start.1 <- start + maxlen - seq.len
                  end.1 <- end + maxlen - seq.len
                  if (names(dev.cur()) == "devSVG") {
                    par(family = "Arial")
                    setSVGShapeToolTip(title = sprintf("Motif # %2d", 
                      abs(mot)), desc1 = paste(ifelse(mot < 0, 
                      "Rev.", "For."), "strand,", start - maxlen, 
                      "to", end - maxlen), desc2 = sprintf("p-value = %.1e", 
                      10^p.val))
                  }
                  if (!is.null(mot.info)) {
                    if (names(dev.cur()) == "devSVG") {
                      if (mot > 0) 
                        rect(start.1, j + 0.01, end.1, j + 0.3, 
                          col = col, border = col)
                      else if (mot < 0) 
                        rect(start.1, j - 0.3, end.1, j - 0.01, 
                          col = col, border = col)
                    }
                    else {
                      if (mot > 0) 
                        rects <- rbind(rects, c(start.1, j + 
                          0.01, end.1, j + 0.3, col = col, border = col))
                      else if (mot < 0) 
                        rects <- rbind(rects, c(start.1, j - 
                          0.3, end.1, j - 0.01, col = col, border = col))
                    }
                  }
                  else {
                    if (names(dev.cur()) == "devSVG") {
                      if (mot > 0) 
                        rect(start.1, j + 0.01, end.1, j + 0.3, 
                          border = col)
                      else if (mot < 0) 
                        rect(start.1, j - 0.3, end.1, j - 0.01, 
                          border = col)
                    }
                    else {
                      if (mot > 0) 
                        rects <- rbind(rects, c(start.1, j + 
                          0.01, end.1, j + 0.3, col = NA, border = col))
                      else if (mot < 0) 
                        rects <- rbind(rects, c(start.1, j - 
                          0.3, end.1, j - 0.01, col = NA, border = col))
                    }
                  }
                }
            }
            if (!is.null(rects)) 
                rect(rects[, 1], rects[, 2], rects[, 3], rects[, 
                  4], col = rects[, 5], border = rects[, 6])
        }
        if (no.plot) 
            next
        slen <- seq.lengths[jj]
        if (all(seq.lengths[!is.na(seq.lengths)]) == 0) 
            slen <- 50
        lines(c(maxlen - slen, maxlen), c(j, j), lwd = lwd + 
            as.integer(rows[jj] %in% o.genes), col = colmap[jj])
        if (!is.null(rows)) {
            label <- rows[jj]
            col <- "black"
            if (exists("all.tfs") && label %in% all.tfs) 
                col <- "tomato3"
            if (names(dev.cur()) == "devSVG" || !long.names && 
                !no.key) 
                text(maxlen * 1.2, j, labels = label, adj = c(1, 
                  0.5), col = col, xpd = NA, ...)
            if (long.names || names(dev.cur()) == "devSVG") {
                g.name <- toupper(label)
                if (exists("gene.coords") && is.vector(gene.coords) && 
                  is.character(gene.coords)) {
                  g.name <- gene.coords[label]
                }
                else {
                  if (exists("gene.coords") && !is.null(gene.coords$gene.func)) 
                    g.name <- gene.coords$gene.func[g.name]
                  if (exists("gene.coords") && !is.null(gene.coords$gene.name) && 
                    gene.coords$gene.name[label] != "-" && !is.na(gene.coords$gene.name[label]) && 
                    toupper(gene.coords$gene.name[label]) != 
                      toupper(g.name)) {
                    g.name <- paste(gene.coords$gene.name[label], 
                      ": ", g.name, sep = "")
                  }
                }
                if (is.na(g.name)) 
                  g.name <- label
                if (names(dev.cur()) == "devSVG") {
                  par(family = "Arial")
                  setSVGShapeURL(paste("http://www.genome.ad.jp/dbget-bin/www_bget?", 
                    organism, ":", label, sep = ""))
                  if (!is.na(g.name)) 
                    setSVGShapeToolTip(label, g.name)
                  else setSVGShapeToolTip(label)
                  rect(maxlen * 1.2, j - 0.18, maxlen, j + 0.18, 
                    col = NA, border = NA, xpd = NA)
                }
                else if (!is.na(g.name)) {
                  lab <- label
                  if (toupper(g.name) != toupper(label) && g.name != 
                    "") {
                    g.name <- gsub("^[:\\s+]+", "", gsub("\\s+$", 
                      "", g.name, perl = T), perl = T)
                    if (names(dev.cur()) == "X11") 
                      g.name <- strtrim(g.name, 40)
                    else gname <- strtrim(g.name, 60)
                    if (label != "") 
                      lab <- paste(g.name, ": ", label, sep = "")
                    else lab <- g.name
                  }
                  if (!no.key) 
                    text(maxlen * 1.2, j, labels = lab, adj = c(1, 
                      0.5), col = col, xpd = NA, ...)
                }
            }
            if (!is.na(p.clust) && !no.key) 
                text(-maxlen * 0.07, j, labels = sprintf("%.2f", 
                  p.values[label]), xpd = NA, col = if (label %in% 
                  names(which(!is.dup.seq))) 
                  "black"
                else "blue", ...)
        }
    }
    if (no.plot) 
        return(out.posns)
    if (!no.key && !is.na(p.clust)) {
        text(-maxlen * 0.15, length(rows) + 0.9, labels = paste("log10(P)   ", 
            seq.type), pos = 4, ...)
        mots.used <- sort(unique(mots.used))
        if (length(mots.used) > 1) {
            text(maxlen * 0.02, length(rows) + 0.9, "Motif legend:", 
                xpd = NA, adj = c(0, 0.5), ...)
            for (j in 1:length(mots.used)) text(maxlen * 0.24 + 
                (j + 0) * maxlen * 0.03, length(rows) + 0.9, 
                as.character(mots.used[j]), col = mots.used[j] + 
                  1, xpd = NA, adj = c(0, 0.5), ...)
        }
        n.unique.seqs <- sum(!is.dup.seq)
        text(maxlen * 1.2, length(rows) + 0.9, sprintf("log10(P.clust)=%.2f; %d sequences; %d unique", 
            p.clust, length(seqs), n.unique.seqs), xpd = NA, 
            adj = c(1, 0.5), ...)
    }
}
preprocess.ratios <-
function (ratios) 
{
    cat("Filtering out nochange rows/cols from ratios matrix...\n")
    ratios <- ratios[apply(ratios, 1, function(i) mean(is.na(i) | 
        i == 0)) < 0.5, ]
    ratios <- ratios[, apply(ratios, 2, function(i) mean(is.na(i) | 
        i == 0)) < 0.5]
    cat("Filtered ratios matrix is", paste(dim(ratios), collapse = "x"), 
        "\n")
    cat("Normalizing ratios matrix...\n")
    ratios <- t(scale(t(ratios), center = apply(ratios, 1, median, 
        na.rm = T), scale = apply(ratios, 1, sd, na.rm = T)))
    ratios
}
pssm.to.string <-
function (pssm, cutoff.1 = 0.7, cutoff.2 = 0.4) 
{
    maxes <- max.col(pssm)
    letters <- col.let[maxes]
    values <- pssm[cbind(1:nrow(pssm), maxes)]
    letters[letters == "A" & values < cutoff.1] <- "a"
    letters[letters == "C" & values < cutoff.1] <- "c"
    letters[letters == "G" & values < cutoff.1] <- "g"
    letters[letters == "T" & values < cutoff.1] <- "t"
    letters[values < cutoff.2] <- "n"
    return(paste(letters, collapse = ""))
}
re.seed.empty.clusters <-
function (toosmall.r = cluster.rows.allowed[1], toosmall.c = 0, 
    n.r = cluster.rows.allowed[1] * 2, n.c = 5) 
{
    rm <- row.membership
    rats <- get.cluster.matrix()
    if (any(tabulate(unlist(apply(rm, 1, unique)), k.clust) <= 
        toosmall.r)) {
        which.zero <- which(tabulate(unlist(apply(rm, 1, unique)), 
            k.clust) <= toosmall.r)
        cat("These", length(which.zero), "clusters have TOO FEW rows: ", 
            which.zero, "\n")
        for (k in which.zero) {
            all.zero <- names(which(apply(rm, 1, function(i) all(i <= 
                toosmall.r))))
            if (length(all.zero) < n.r) {
                all.zero <- unique(c(all.zero, rownames(which(rm == 
                  0, arr = T))))
                all.zero <- unique(c(all.zero, names(which(apply(rm, 
                  1, function(i) all(i == i[1]))))))
            }
            if (length(all.zero) <= 1) 
                break
            gs <- sample(all.zero, 1)
            cors <- apply(rats[all.zero, ], 1, cor, rats[gs, 
                ], use = "pairwise")
            gs <- names(cors[order(cors, decreasing = T)[1:n.r]])
            gs <- gs[!is.na(gs)]
            for (g in gs) {
                if (any(rm[g, ] == 0)) 
                  rm[g, which(rm[g, ] == 0)[1]] <- k
                else rm[g, 1] <- k
            }
        }
        for (tt in names(mot.weights)) for (k in which.zero) meme.scores[[tt]][[k]] <- list(iter = iter)
    }
    cm <- col.membership
    if (any(tabulate(cm, k.clust) <= toosmall.c)) {
        which.zero <- which(tabulate(cm, k.clust) <= toosmall.c)
        cat("These", length(which.zero), "clusters have TOO FEW columns: ", 
            which.zero, "\n")
        for (k in which.zero) {
            all.zero <- names(which(apply(cm, 1, function(i) all(i <= 
                toosmall.c))))
            if (length(all.zero) <= n.c) 
                all.zero <- unique(c(all.zero, rownames(which(cm == 
                  0, arr = T))))
            if (length(all.zero) <= 1) 
                break
            cs <- unique(sample(all.zero, min(length(all.zero), 
                n.c)))
            cs <- cs[!is.na(cs)]
            for (cc in cs) cm[cc, which(cm[cc, ] == 0)[1]] <- k
        }
    }
    invisible(list(r = rm, c = cm, ms = meme.scores))
}
remove.low.complexity <-
function (seqs, length = 8, entropy.cutoff = 0.6, repl = "N", 
    use.dust = T, seq.type = "upstream") 
{
    read.fasta <- function(fname, lines = NULL) {
        if (is.null(lines)) 
            lines <- readLines(fname)
        lines <- lines[lines != ""]
        starts <- grep("^>", lines, perl = T)
        if (length(starts) > 1) 
            stops <- c(starts[2:length(starts)], length(lines) + 
                1)
        else stops <- length(lines) + 1
        seqs <- sapply(1:length(starts), function(i) paste(lines[(starts[i] + 
            1):(stops[i] - 1)], collapse = "", sep = ""))
        names(seqs) <- gsub("^>", "", lines[starts], perl = T)
        seqs
    }
    write.fasta <- function(seqs, fname) writeLines(paste(paste(">", 
        names(seqs), sep = ""), seqs, sep = "\n"), con = fname)
    if (use.dust) {
        if (!file.exists("progs/dust")) 
            warning("For best results, install dust in progs/ directory.")
        else {
            seqs <- seqs[!is.null(seqs) & !is.na(seqs)]
            seqs <- seqs[nchar(seqs) >= motif.width.range[[seq.type]][2]]
            fname <- tempfile("dust.fst.")
            write.fasta(seqs, fname)
            fst <- system.time.limit(paste("progs/dust", fname, 
                "2>/dev/null"), tlimit = 60)
            unlink(fname)
            seqs <- read.fasta(NULL, fst)
            return(seqs)
        }
    }
    shannon.entropy <- function(string) {
        ni <- table(string)/length + 1e-10
        -sum(ni * log2(ni))
    }
    all.dna.seqs <- function(l, lett = c("G", "A", "T", "C"), 
        as.matrix = F) {
        n.lett <- length(lett)
        out <- sapply(1:l, function(ll) rep(as.vector(sapply(lett, 
            function(i) rep(i, n.lett^(ll - 1)))), n.lett^(l - 
            ll)))
        if (as.matrix) 
            return(out)
        apply(out, 1, paste, collapse = "")
    }
    substrings <- all.dna.seqs(l = length)
    mc <- get.parallel(length(substrings))
    bad.substrings <- substrings[unlist(mc$apply(strsplit(substrings, 
        NULL), shannon.entropy)) <= entropy.cutoff]
    repl <- paste(rep(repl, length), sep = "", collapse = "")
    in.seqs <- seqs
    mc <- get.parallel(length(seqs))
    seqs <- unlist(mc$apply(1:length(seqs), function(i) {
        seq <- seqs[i]
        for (s in bad.substrings) seq <- gsub(s, repl, seq)
        seq
    }))
    names(seqs) <- names(in.seqs)
    return(seqs)
}
residual.submatrix <-
function (rats, rows, cols, varNorm = FALSE) 
{
    rows <- rows[rows %in% rownames(rats)]
    cols <- cols[cols %in% colnames(rats)]
    if (length(rows) <= 1 || length(cols) <= 1) 
        return(1)
    maxRowVar <- attr(rats, "maxRowVar")
    rats <- rats[rows, cols]
    if (is.vector(rats) || any(dim(rats) <= 1) || mean(is.na(rats)) > 
        0.95) 
        return(1)
    d.rows <- rowMeans(rats, na.rm = T)
    d.cols <- colMeans(rats, na.rm = T)
    d.all <- mean(d.rows, na.rm = T)
    rij <- rats + d.all
    rij <- rij - matrix(d.cols, nrow = nrow(rij), ncol = ncol(rij), 
        byrow = T)
    rij <- rij - matrix(d.rows, nrow = nrow(rij), ncol = ncol(rij), 
        byrow = F)
    average.r <- mean(abs(rij), na.rm = TRUE)
    if (varNorm) {
        row.var <- mean(apply(rats, 1, var, use = "pairwise.complete.obs"), 
            na.rm = T)
        if (is.na(row.var) || row.var > maxRowVar) 
            row.var <- maxRowVar
        average.r <- average.r/row.var
    }
    average.r
}
rev.comp <-
function (seqs) 
{
    sapply(seqs, function(seq) paste(rev(strsplit(toupper(chartr("ATCG", 
        "tagc", seq)), "")[[1]]), collapse = ""))
}
runMast <-
function (memeOut, genes, seqs, addl.args = mast.addl.args$upstream, 
    bgseqs = NULL, bg.list = NULL, e.value.cutoff = 99999, p.value.cutoff = 0.5, 
    motif.e.value.cutoff = 99999, unlink = T, verbose = F, ...) 
{
    fname <- tempfile("mast.tmp.fst.")
    bgfname <- tempfile("mast.tmp.bg.")
    memeOutFname <- tempfile("meme.tmp.out.")
    cat(memeOut, sep = "\n", file = memeOutFname)
    tmp <- mkTempMemeFiles(genes, seqs, seq.weights = NA, fname = fname, 
        bgseqs = bgseqs, bg.list = bg.list, bgfname = bgfname, 
        ...)
    if (tmp <= 0) 
        return(NULL)
    bgtmp <- paste("-bfile", bgfname)
    if (is.null(bgfname) || !file.exists(bgfname)) 
        bgtmp <- ""
    cmd <- paste(mast.cmd, memeOutFname, "-d", fname, bgtmp, 
        "-nostatus -stdout -text", "-brief", addl.args)
    if (verbose) 
        cat(cmd, "\n")
    output <- system.time.limit(cmd, tlimit = 600)
    if (unlink) 
        unlink(c(memeOutFname, fname, bgfname))
    output
}
runMeme <-
function (sgenes, seqs, seq.weights = NA, bgseqs = NULL, bgfname = NULL, 
    bg.list = NULL, nmotif = 1, unlink = T, addl.args = "", verbose = T, 
    ...) 
{
    fname <- tempfile("meme.tmp.fst.")
    bgfname <- tempfile("meme.tmp.bg.")
    tmp <- mkTempMemeFiles(sgenes, seqs, seq.weights, fname = fname, 
        bgseqs = bgseqs, bg.list = bg.list, bgfname = bgfname, 
        ...)
    if (tmp <= 0) 
        return(NULL)
    bgtmp <- paste("-bfile", bgfname)
    if (is.null(bgfname) || !file.exists(bgfname)) 
        bgtmp <- ""
    cmd <- paste(meme.cmd, fname, bgtmp, "-nostatus -text", addl.args)
    if (verbose) 
        cat(cmd, "\n")
    output <- system.time.limit(cmd, tlimit = 600)
    if (unlink) 
        unlink(c(fname, bgfname))
    return(output)
}
save.cmonkey.env <-
function (env, file = paste(env$cmonkey.filename, ".RData", sep = ""), 
    restore = T) 
{
    if (env$big.matrices > 0 && require(ff)) {
        tmp <- list()
        for (i in c("row.scores", "mot.scores", "net.scores", 
            "r.scores", "rr.scores", "col.scores", "net.scores", 
            "row.memb", "col.memb")) {
            tmp[[i]] <- env[[i]]
            if (!is.null(env[[i]]) && is.ff(env[[i]])) 
                env[[i]] <- env[[i]][, ]
        }
        for (i in names(env$meme.scores)) {
            tmp[[i]] <- list()
            if (!is.null(env$meme.scores[[i]]$all.pv) && is.ff(env$meme.scores[[i]]$all.pv)) {
                tmp[[i]]$all.pv <- env$meme.scores[[i]]$all.pv
                env$meme.scores[[i]]$all.pv <- env$meme.scores[[i]]$all.pv[, 
                  ]
            }
            if (!is.null(env$meme.scores[[i]]$all.ev) && is.ff(env$meme.scores[[i]]$all.ev)) {
                tmp[[i]]$all.ev <- env$meme.scores[[i]]$all.ev
                env$meme.scores[[i]]$all.ev <- env$meme.scores[[i]]$all.ev[, 
                  ]
            }
        }
    }
    save.image(file)
    if (restore && env$big.matrices > 0 && require(ff)) {
        for (i in c("row.scores", "mot.scores", "net.scores", 
            "r.scores", "rr.scores", "col.scores", "net.scores", 
            "row.memb", "col.memb")) env[[i]] <- tmp[[i]]
        for (i in names(env$meme.scores)) {
            if (!is.null(tmp[[i]]$all.pv) && is.ff(tmp[[i]]$all.pv)) 
                env$meme.scores[[i]]$all.pv <- tmp[[i]]$all.pv
            if (!is.null(tmp[[i]]$all.ev) && is.ff(tmp[[i]]$all.ev)) 
                env$meme.scores[[i]]$all.ev <- tmp[[i]]$all.ev
        }
    }
    NULL
}
seed.clusters <-
function (k.clust, seed.method = "rnd", col.method = "rnd") 
{
    if (seed.method == "custom" && exists("seed.clusters.custom")) 
        return(seed.clusters.custom(k.clust, col.method))
    if (substr(seed.method, 1, 3) == "net" && length(networks) <= 
        0) {
        cat("Seed method is", seed.method, ", but no networks -- using 'kmeans' instead.\n")
        seed.method <- "kmeans"
    }
    if (seed.method == "rnd") {
        row.membership <- t(sapply(1:attr(ratios, "nrow"), function(i) sample(1:k.clust, 
            n.clust.per.row[1])))
    }
    else if (substr(seed.method, 1, 5) == "list=") {
        row.membership <- matrix(0, nrow = attr(ratios, "nrow"), 
            ncol = n.clust.per.row[1])
        rownames(row.membership) <- attr(ratios, "rnames")
        fname <- strsplit(seed.method, "=")[[1]][2]
        if (exists(fname)) 
            lists <- get(fname)
        else if (file.exists(fname)) 
            lists <- strsplit(readLines(fname), split = "[ \t,]", 
                perl = T)
        for (k in 1:min(c(k.clust, length(lists)))) {
            row.membership[lists[[k]][row.membership[lists[[k]], 
                1] == 0], 1] <- k
            row.membership[lists[[k]][row.membership[lists[[k]], 
                1] != 0], 2] <- k
        }
        if (length(lists) < k.clust) {
            for (k in (length(lists) + 1):k.clust) {
                rows <- sample(attr(ratios, "rnames"), 5)
                row.membership[rows[row.membership[rows, 1] == 
                  0], 1] <- k
                row.membership[rows[row.membership[rows, 1] != 
                  0 & row.membership[rows, 2] == 0], 2] <- k
            }
        }
    }
    else if (substr(seed.method, 1, 4) == "rnd=") {
        n.samp <- as.integer(strsplit(seed.method, "=")[[1]][2])
        row.membership <- matrix(0, nrow = attr(ratios, "nrow"), 
            ncol = n.clust.per.row[1])
        rownames(row.membership) <- attr(ratios, "rnames")
        for (i in 1:n.clust.per.row) {
            sampled <- rep(FALSE, attr(ratios, "nrow"))
            names(sampled) <- attr(ratios, "rnames")
            for (k in 1:k.clust) {
                g <- sample(attr(ratios, "rnames")[!sampled], 
                  n.samp)
                row.membership[g, 1] <- k
                sampled[g] <- TRUE
            }
        }
    }
    else if (seed.method == "kmeans") {
        if (!exists("ratios")) 
            stop("kmeans seed method but no ratios")
        tmp.rat <- get.cluster.matrix()
        tmp.rat[is.na(tmp.rat)] <- 0
        row.membership <- kmeans(tmp.rat, centers = k.clust, 
            iter.max = 20, nstart = 2)$cluster
        if (n.clust.per.row[1] > 1) 
            row.membership <- cbind(row.membership, matrix(rep(0, 
                attr(ratios, "nrow") * (n.clust.per.row[1] - 
                  1), ncol = n.clust.per.row[1] - 1)))
    }
    else if (substr(seed.method, 1, 11) == "trimkmeans=") {
        if (!exists("ratios")) 
            stop("trimkmeans seed method but no ratios")
        require(trimcluster)
        trim <- as.numeric(strsplit(seed.method, "=")[[1]][2])
        tmp.rat <- get.cluster.matrix()
        tmp.rat[is.na(tmp.rat)] <- 0
        row.membership <- trimkmeans(tmp.rat, k.clust, trim = trim, 
            maxit = 20, runs = 2)$classification
        if (n.clust.per.row[1] > 1) 
            row.membership <- cbind(row.membership, matrix(rep(0, 
                attr(ratios, "nrow") * (n.clust.per.row[1] - 
                  1), ncol = n.clust.per.row[1] - 1)))
    }
    else if (substr(seed.method, 1, 4) == "cor=") {
        if (!exists("ratios")) 
            stop("cor seed method but no ratios")
        n.cor <- as.integer(strsplit(seed.method, "=")[[1]][2])
        rats <- get.cluster.matrix()
        cors <- if (attr(ratios, "nrow") < 6000) 
            cor(t(rats), use = "pairwise")
        else NULL
        rm <- rep(0, attr(ratios, "nrow"))
        names(rm) <- attr(ratios, "rnames")
        sampled <- rep(FALSE, attr(ratios, "nrow"))
        names(sampled) <- attr(ratios, "rnames")
        mc <- get.parallel(n.clust.per.row)
        tmp <- mc$apply(1:n.clust.per.row, function(i) {
            for (k in 1:k.clust) {
                if (sum(!sampled) < n.cor) 
                  sampled[sample(1:length(sampled))] <- FALSE
                rnames <- attr(ratios, "rnames")[!sampled]
                g <- sample(rnames, 1)
                if (!is.null(cors)) 
                  g <- rnames[order(cors[g, !sampled], decreasing = T)[1:n.cor]]
                else g <- rnames[order(apply(rats[!sampled, ], 
                  1, cor, rats[g, ]), decreasing = T)[1:n.cor]]
                rm[g] <- k
                if (length(g) == 1) {
                  if (!is.null(cors)) 
                    tmp <- rnames[order(cors[g, !sampled], decreasing = T)[1:10]]
                  else tmp <- rnames[order(apply(rats[!sampled, 
                    ], 1, cor, rats[g, ]), decreasing = T)[1:10]]
                  sampled[tmp] <- TRUE
                }
                sampled[g] <- TRUE
            }
            rm[attr(ratios, "rnames")]
        })
        row.membership <- do.call(cbind, tmp)
    }
    else if (substr(seed.method, 1, 4) == "net=") {
        if (!exists("networks") || length(networks) <= 0) 
            stop("net seed method but no networks")
        seed.method <- strsplit(seed.method, "=")[[1]][2]
        net.name <- strsplit(seed.method, ":")[[1]][1]
        net <- networks[[net.name]]
        n.seed <- as.integer(strsplit(seed.method, ":")[[1]][2])
        rm <- rep(0, attr(ratios, "nrow"))
        names(rm) <- attr(ratios, "rnames")
        sampled <- rep(FALSE, length(unique(as.character(net$protein1))))
        names(sampled) <- unique(as.character(net$protein1))
        mc <- get.parallel(n.clust.per.row)
        tmp <- mc$apply(1:n.clust.per.row, function(i) {
            for (k in 1:k.clust) {
                if (sum(!sampled) <= 0) 
                  sampled[1:length(sampled)] <- FALSE
                rnames <- names(which(!sampled))
                gs <- sample(rnames, 1)
                qiter <- 0
                while (length(gs) < n.seed && qiter < 20) {
                  ns <- as.character(net$protein2[as.character(net$protein1) %in% 
                    gs])
                  if (length(ns) + length(gs) >= n.seed) 
                    ns <- sample(ns, size = n.seed - length(gs), 
                      prob = net$combined_score[as.character(net$protein1) %in% 
                        gs])
                  gs <- unique(c(gs, ns))
                  qiter <- qiter + 1
                }
                rm[gs] <- k
                sampled[gs] <- TRUE
                if (n.seed <= 2) 
                  sampled[as.character(net$protein2[as.character(net$protein1) %in% 
                    gs])] <- TRUE
            }
            rm[attr(ratios, "rnames")]
        })
        row.membership <- do.call(cbind, tmp)
    }
    else if (substr(seed.method, 1, 7) == "netcor=") {
        if (!exists("ratios")) 
            stop("netcor seed method but no ratios")
        if (!exists("networks") || length(networks) <= 0) 
            stop("netcor seed method but no networks")
        seed.method <- strsplit(seed.method, "=")[[1]][2]
        net.name <- strsplit(seed.method, ":")[[1]][1]
        net <- networks[[net.name]]
        n.seed <- as.integer(strsplit(seed.method, ":")[[1]][2])
        rats <- get.cluster.matrix()
        cors <- cor(t(rats), use = "pairwise")
        tmp.mat <- matrix(0, nrow = nrow(cors), ncol = ncol(cors))
        dimnames(tmp.mat) <- dimnames(cors)
        tmp.lookup <- 1:attr(ratios, "nrow")
        names(tmp.lookup) <- attr(ratios, "rnames")
        net <- net[as.character(net$protein1) %in% attr(ratios, 
            "rnames") & as.character(net$protein2) %in% attr(ratios, 
            "rnames"), ]
        tmp.mat[cbind(tmp.lookup[as.character(net$protein1)], 
            tmp.lookup[as.character(net$protein2)])] <- net$combined_score/1000
        cors <- cors + tmp.mat
        rm(tmp.mat)
        rm <- rep(0, attr(ratios, "nrow"))
        names(rm) <- attr(ratios, "rnames")
        sampled <- rep(FALSE, attr(ratios, "nrow"))
        names(sampled) <- attr(ratios, "rnames")
        mc <- get.parallel(n.clust.per.row)
        tmp <- mc$apply(1:n.clust.per.row, function(i) {
            for (k in 1:k.clust) {
                if (sum(!sampled) < n.seed) 
                  sampled[sample(1:length(sampled))] <- FALSE
                rnames <- attr(ratios, "rnames")[!sampled]
                g <- sample(rnames, 1)
                g <- rnames[order(cors[g, !sampled], decreasing = T)[1:n.seed]]
                rm[g] <- k
                if (length(g) == 1) {
                  tmp <- rnames[order(cors[g, !sampled], decreasing = T)[1:10]]
                  sampled[tmp] <- TRUE
                }
                sampled[g] <- TRUE
            }
            rm[attr(ratios, "rnames")]
        })
        row.membership <- do.call(cbind, tmp)
    }
    if (is.vector(row.membership)) 
        row.membership <- t(row.membership)
    if (nrow(row.membership) == 1) 
        row.membership <- t(row.membership)
    rownames(row.membership) <- attr(ratios, "rnames")
    if (col.method == "rnd") {
        col.membership <- t(sapply(1:attr(ratios, "ncol"), function(i) sample(1:k.clust, 
            n.clust.per.col[1], replace = F)))
    }
    else if (col.method == "best") {
        if (!exists("ratios")) 
            stop("best col seed method but no ratios")
        all.rats <- get.cluster.matrix()
        attr(all.rats, "all.colVars") <- apply(all.rats, 2, var, 
            use = "pair", na.rm = T)
        col.scores <- -sapply(1:k.clust, function(k) if (sum(row.membership == 
            k, na.rm = T) <= 0) 
            rep(NA, attr(ratios, "ncol"))
        else get.col.scores(k = get.rows(k, row.membership), 
            ratios = all.rats))
        col.membership <- t(apply(col.scores, 1, function(i) order(i, 
            decreasing = T)[1:n.clust.per.col[1]]))
    }
    rownames(col.membership) <- attr(ratios, "cnames")
    list(row.membership = row.membership, col.membership = col.membership)
}
set.param <-
function (name, val, env = cmonkey.params, override = F, quiet = F) 
{
    if (!exists(name, envir = env) || override) {
        if (!quiet) 
            try({
                cat(name, "-> ")
                str(val, no.list = T)
            })
        assign(name, val, envir = env)
    }
    else {
        val <- get(name, envir = env)
        if (!quiet) 
            try({
                cat(name, "= ")
                str(val, no.list = T)
            })
        assign(name, val, envir = env)
    }
    assign(name, val, envir = parent.frame())
}
system.time.limit <-
function (cmd, tlimit = 600) 
{
    readLines(pipe(cmd, "rt"))
}
update.cmonkey.env <-
function (env) 
{
    if (file.exists("cmonkey-funcs.R")) {
        tmp.e <- new.env()
        sys.source("cmonkey-funcs.R", envir = tmp.e)
    }
    else {
        tmp.e <- environment(cMonkey:::cmonkey)
    }
    for (i in ls(tmp.e)) {
        if (i %in% c("DATE", "VERSION")) 
            next
        f <- try(get(i, envir = tmp.e))
        f2 <- try(get(paste("super", i, sep = "."), envir = env), 
            silent = T)
        if (class(f) == "function") {
            environment(f) <- env
            if (class(f2) != "function") 
                assign(i, f)
            else assign(paste("super", i, sep = "."), f)
        }
    }
    rm(f, f2, tmp.e, i)
    for (i in ls()) {
        if (i %in% c("i", "env")) 
            next
        f <- get(i)
        if (is.function(f)) 
            assign(i, f, env)
    }
    if (env$big.matrices > 0 && require(ff)) {
        for (i in c("row.scores", "mot.scores", "net.scores", 
            "r.scores", "rr.scores", "col.scores", "net.scores", 
            "row.memb", "col.memb")) if (!is.null(env[[i]]) && 
            is.ff(env[[i]])) 
            open.ff(get(i, env))
        for (i in 1:length(env$meme.scores)) {
            if (!is.null(env$meme.scores[[i]]$all.pv) && is.ff(env$meme.scores[[i]]$all.pv)) 
                open.ff(env$meme.scores[[i]]$all.pv)
            if (!is.null(env$meme.scores[[i]]$all.ev) && is.ff(env$meme.scores[[i]]$all.ev)) 
                open.ff(env$meme.scores[[i]]$all.ev)
        }
    }
}
viewPssm <-
function (pssm, e.val = NA, mot.ind = NA, use.char = T, main.title = NA, 
    ...) 
{
    if (is.null(pssm)) 
        return()
    getEntropy <- function(pssm) {
        pssm[pssm == 0] <- 1e-05
        entropy <- apply(pssm, 1, function(i) -sum(i * log2(i)))
        return(entropy)
    }
    char.coords = list(T = list(x = c(0.45, 0.55, 0.55, 1, 1, 
        0, 0, 0.45), y = c(0, 0, 0.9, 0.9, 1, 1, 0.9, 0.9), color = 2), 
        A = list(x = c(0, 0.1, 0.28, 0.72, 0.68, 0.32, 0.5, 0.9, 
            1, 0.55, 0.45, 0), y = c(0, 0, 0.4, 0.4, 0.5, 0.5, 
            0.9, 0, 0, 1, 1, 0), color = 3), C = list(x = c(1, 
            1, 0.85, 0.55, 0.45, 0.15, 0, 0, 0.15, 0.45, 0.55, 
            0.85, 1, 1, 0.9, 0.9, 0.8, 0.55, 0.45, 0.2, 0.1, 
            0.1, 0.2, 0.45, 0.55, 0.8, 0.9, 0.9), y = c(0.6, 
            0.7, 0.9, 1, 1, 0.9, 0.65, 0.35, 0.1, 0, 0, 0.1, 
            0.35, 0.4, 0.4, 0.35, 0.2, 0.1, 0.1, 0.2, 0.42, 0.58, 
            0.8, 0.9, 0.9, 0.8, 0.65, 0.6), color = 4), G = list(x = c(1, 
            1, 0.85, 0.55, 0.45, 0.15, 0, 0, 0.15, 0.45, 0.55, 
            0.85, 1, 1, 0.7, 0.7, 0.9, 0.8, 0.55, 0.45, 0.2, 
            0.1, 0.1, 0.2, 0.45, 0.55, 0.8, 0.9, 0.9), y = c(0.6, 
            0.7, 0.9, 1, 1, 0.9, 0.65, 0.35, 0.1, 0, 0, 0.1, 
            0.35, 0.5, 0.5, 0.4, 0.4, 0.2, 0.1, 0.1, 0.2, 0.42, 
            0.58, 0.8, 0.9, 0.9, 0.8, 0.65, 0.6), color = "orange"))
    draw.char <- function(char = col.let, rect = c(0, 0, 1, 1)) {
        if (rect[4] <= 1e-05) 
            return()
        x <- char.coords[[char]]$x * rect[3] + rect[1]
        y <- char.coords[[char]]$y * rect[4] + rect[2]
        color <- char.coords[[char]]$color
        polygon(x, y, col = color, border = color)
    }
    win.size <- nrow(pssm)
    par(mar = rep(0.5, 4) + 0.1, mgp = c(3, 1, 0) * 0.75)
    if (any(pssm > 1)) 
        pssm <- t(apply(pssm, 1, function(i) i/sum(i)))
    entr <- getEntropy(pssm)
    scale.e <- (2 - entr)/2
    scale.e[scale.e < 0.05] <- 0.05
    x.range <- c(0.5, win.size + 0.5)
    y.range <- c(0, 1)
    plot(x.range, y.range, type = "n", tck = 0.01, cex.lab = 0.2, 
        cex.sub = 0.2, cex.axis = 0.2, axes = F)
    if (!is.na(main.title[1])) {
        if (!is.na(mot.ind)) 
            title(main.title, col.main = mot.ind + 1, xpd = NA, 
                ...)
        else title(main.title, xpd = NA, ...)
    }
    else if (!is.na(mot.ind)) {
        tmp.tit <- paste("PSSM #", mot.ind, sep = "")
        if (!is.na(e.val)) 
            tmp.tit <- paste(tmp.tit, ": E=", e.val, sep = "")
        title(tmp.tit, col.main = mot.ind + 1, xpd = NA, ...)
    }
    pssm.sc <- scale.e * pssm
    for (j in 1:win.size) {
        inds <- sort(pssm.sc[j, ], index = T)$ix
        for (i in 1:4) {
            ind <- inds[i]
            if (i == 1) {
                if (!use.char) {
                  rect((j - 0.5), 0, (j + 0.5), pssm.sc[j, ind], 
                    col = colMap[ind])
                  if (pssm[j, ind] > 0.05) 
                    text(j, 0 + pssm.sc[j, ind]/2, colLet[ind])
                }
                else {
                  draw.char(col.let[ind], c((j - 0.4), 0, 0.9, 
                    pssm.sc[j, ind] - 0.01))
                }
                prev.h <- pssm.sc[j, ind]
            }
            else {
                if (!use.char) {
                  rect((j - 0.5), prev.h, (j + 0.5), (pssm.sc[j, 
                    ind] + prev.h), col = colMap[ind])
                  if (pssm.sc[j, ind] > 0.05) {
                    if (i == 2) 
                      text(j, prev.h + 0.5 * pssm.sc[j, ind], 
                        colLet[ind], col = 8)
                    else text(j, prev.h + 0.5 * pssm.sc[j, ind], 
                      colLet[ind])
                  }
                }
                else {
                  draw.char(col.let[ind], c((j - 0.4), prev.h, 
                    0.9, pssm.sc[j, ind] - 0.01))
                }
                prev.h <- prev.h + pssm.sc[j, ind]
            }
        }
        if (win.size < 10) 
            text(1:win.size, rep(-0.01, win.size), as.character(1:win.size), 
                cex = 0.7, adj = c(0.5, 1), xpd = NA)
        else if (win.size < 20) 
            text(seq(1, win.size, 2), rep(-0.01, win.size), as.character(seq(1, 
                win.size, 2)), cex = 0.7, adj = c(0.5, 1), xpd = NA)
        else text(seq(1, win.size, 5), rep(-0.01, win.size), 
            as.character(seq(1, win.size, 5)), cex = 0.7, adj = c(0.5, 
                1), xpd = NA)
    }
}
write.project <-
function (dev = "SVG", ks = sapply(clusterStack, "[[", "k"), 
    save.session = F, pdfs = T, out.dir = NULL, gaggle = T, seq.type = "upstream", 
    ...) 
{
    if (is.null(out.dir)) 
        out.dir <- cmonkey.filename
    cat("Outputing to", out.dir, "\n")
    if (!is.null(dev) && dev == "SVG") 
        require(RSVGTipsDevice)
    if (!file.exists(out.dir) && !is.null(dev) && dev == "SVG") 
        dir.create(out.dir, recursive = T, showWarnings = F)
    require(igraph)
    require(hwriter)
    clusterStack <- clusterStack[ks]
    mc <- get.parallel(length(ks))
    if (!file.exists(paste(out.dir, "/svgs", sep = ""))) 
        dir.create(paste(out.dir, "/svgs", sep = ""), showWarnings = F)
    if (pdfs && !file.exists(paste(out.dir, "/pdfs", sep = ""))) 
        dir.create(paste(out.dir, "/pdfs", sep = ""), showWarnings = F)
    if (!file.exists(paste(out.dir, "/htmls", sep = ""))) 
        dir.create(paste(out.dir, "/htmls", sep = ""), showWarnings = F)
    if (!is.null(dev) && dev == "SVG") {
        if (!file.exists(sprintf("%s/svgs/stats.svg", out.dir))) {
            cat("STATS...\n")
            devSVGTips(sprintf("%s/svgs/stats.svg", out.dir), 
                toolTipMode = 2, title = "Biclustering statistics", 
                xmlHeader = T)
            par(family = "Arial")
            plot.stats(new.dev = F)
            dev.off()
        }
        cat("SVGS: ")
        mc$apply(1:length(clusterStack), function(i) {
            k <- ks[i]
            if (k%%25 == 0) 
                cat(k)
            else cat(".")
            if (file.exists(sprintf("%s/svgs/cluster%03d.svg", 
                out.dir, k))) 
                return(NULL)
            devSVGTips(sprintf("%s/svgs/cluster%03d.svg", out.dir, 
                k), toolTipMode = 2, title = sprintf("Bicluster %03d", 
                k), xmlHeader = T)
            try(plotClust(k, T, seq.type = seq.type, ...))
            dev.off()
        })
        cat("\n")
        if (pdfs) {
            cat("PDFS: ")
            mc$apply(1:length(clusterStack), function(i) {
                k <- ks[i]
                if (k%%25 == 0) 
                  cat(k)
                else cat(".")
                if (file.exists(sprintf("%s/pdfs/cluster%03d.pdf", 
                  out.dir, k))) 
                  return(NULL)
                pdf(sprintf("%s/pdfs/cluster%03d.pdf", out.dir, 
                  k))
                try(plotClust(k, T, seq.type = seq.type, ...))
                dev.off()
            })
            cat("\n")
        }
        if (gaggle) {
            cat("HTMLS: ")
            mc$apply(1:length(clusterStack), function(k, ...) {
                if (k%%25 == 0) 
                  cat(k)
                else cat(".")
                if (file.exists(sprintf("%s/htmls/cluster%03d.html", 
                  out.dir, k))) 
                  return()
                rows <- sort(get.rows(k))
                short.names <- get.long.names(rows, short = T)
                short.names <- cbind(rows, short.names)
                rownames(short.names) <- colnames(short.names) <- NULL
                long.names <- get.long.names(rows, short = F)
                long.names <- cbind(rows, long.names)
                rownames(long.names) <- colnames(long.names) <- NULL
                refseq.names <- unique(unlist(get.synonyms(rows)))
                refseq.names <- grep("^NP_", refseq.names, val = T)
                upstream.seqs <- try(get.sequences(k), silent = T)
                if (class(upstream.seqs) == "try-error") {
                  upstream.seqs <- rep("", length(rows))
                  names(upstream.seqs) <- rows
                }
                upstream.seqs <- cbind(names(upstream.seqs), 
                  upstream.seqs)
                rownames(upstream.seqs) <- colnames(upstream.seqs) <- NULL
                htmltext <- paste(c("<html><head><title>Bicluster %K (%FILE)</title>", 
                  "<style type=\"text/css\">", "  .hidden {", 
                  "     display: none;", "   }", "  .gaggle-data {", 
                  "     color: green;", "     font-size: xx-small;", 
                  "   }", "   p {", "     color: red;", "     font-size: x-small;", 
                  "   }", "</style>", "<script type=\"text/javascript\">", 
                  "   function toggleVisible(id){", "      if (document.getElementById){", 
                  "         obj = document.getElementById(id);", 
                  "         if (obj) {", "            if (obj.style.display == 'none'){", 
                  "               obj.style.display = 'block';", 
                  "            } else {", "               obj.style.display = 'none';", 
                  "            }", "         }", "      }", "   }", 
                  "</script>", "</head>", "<table><tr><td>", 
                  "<iframe src=\"../svgs/cluster%K03d%K.svg\" width=\"600\" height=\"520\" frameborder=\"0\"></iframe>", 
                  "</td><td>", "<p><a href=\"#bicluster%K03d%K\" onclick=\"toggleVisible('bicluster%K03d%K'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K rows and columns.</p>", 
                  "<div id=\"bicluster%K03d%K\" style=\"display:none;\" class=\"gaggle-data bicluster\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%dx%d</span>", 
                    length(rows), length(get.cols(k))), "   <div class=\"gaggle-cluster\">", 
                  "      <ol class=\"gaggle-rowNames\">", paste("<li>", 
                    sort(rows), "</li>", sep = "", collapse = ""), 
                  "      </ol>", "   <ol class=\"gaggle-columnNames\">", 
                  paste("<li>", sort(get.cols(k)), "</li>", sep = "", 
                    collapse = ""), "      </ol>", "   </div>", 
                  "</div>", "<p><a href=\"#bicluster%K03d%K_genes\" onclick=\"toggleVisible('bicluster%K03d%K_genes'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K rows (genes).</p>", 
                  "<div id=\"bicluster%K03d%K_genes\" style=\"display:none;\" class=\"gaggle-data genes\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K genes</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%d</span>", 
                    length(rows)), "   <div class=\"gaggle-namelist\">", 
                  "      <ol>", paste("<li>", sort(rows), "</li>", 
                    sep = "", collapse = ""), "      </ol>", 
                  "   </div>", "</div>", "<p><a href=\"#bicluster%K03d%K_short_names\" onclick=\"toggleVisible('bicluster%K03d%K_short_names'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K rows (short gene names).</p>", 
                  "<div id=\"bicluster%K03d%K_short_names\" style=\"display:none;\" class=\"gaggle-data genes\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K short names</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%d</span>", 
                    nrow(short.names)), "   <span class=\"gaggle-namelist-tag hidden\">short_name</span>", 
                  hwrite(short.names, table.class = "toc", col.class = list(NA, 
                    "short_name"), border = 1, table.style = "font-family: monospace; font-size: xx-small; color: green; border-collapse: collapse"), 
                  "   </div>", "<p><a href=\"#bicluster%K03d%K_long_names\" onclick=\"toggleVisible('bicluster%K03d%K_long_names'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K rows (long gene names).</p>", 
                  "<div id=\"bicluster%K03d%K_long_names\" style=\"display:none;\" class=\"gaggle-data genes\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K long names</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%d</span>", 
                    nrow(long.names)), "   <span class=\"gaggle-namelist-tag hidden\">long_name</span>", 
                  hwrite(long.names, table.class = "toc", col.class = list(NA, 
                    "long_name"), border = 1, table.style = "font-family: monospace; font-size: xx-small; color:green; border-collapse: collapse"), 
                  "   </div>", "<p><a href=\"#bicluster%K03d%K_refseq_names\" onclick=\"toggleVisible('bicluster%K03d%K_refseq_names'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K rows (NCBI RefSeq gene IDs).</p>", 
                  "<div id=\"bicluster%K03d%K_refseq_names\" style=\"display:none;\" class=\"gaggle-data genes\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K NCBI RefSeq IDs</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%d</span>", 
                    length(refseq.names)), "   <div class=\"gaggle-namelist\">", 
                  "      <ol>", paste("<li>", sort(refseq.names), 
                    "</li>", sep = "", collapse = ""), "      </ol>", 
                  "   </div>", "</div>", "<p><a href=\"#bicluster%K03d%K_upstream_seqs\" onclick=\"toggleVisible('bicluster%K03d%K_upstream_seqs'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K gene upstream sequences.</p>", 
                  "<div id=\"bicluster%K03d%K_upstream_seqs\" style=\"display:none;\" class=\"gaggle-data genes\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K upstream sequences</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%d</span>", 
                    nrow(upstream.seqs)), "   <span class=\"gaggle-namelist-tag hidden\">upstream</span>", 
                  hwrite(upstream.seqs, table.class = "toc", 
                    col.class = list(NA, "upstream"), border = 1, 
                    table.style = "font-family: monospace; font-size: xx-small; color:green; border-collapse: collapse"), 
                  "   </div>", "<p><a href=\"#bicluster%K03d%K_arrays\" onclick=\"toggleVisible('bicluster%K03d%K_arrays'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K columns (arrays; conditions).</p>", 
                  "<div id=\"bicluster%K03d%K_arrays\" style=\"display:none;\" class=\"gaggle-data arrays\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K arrays</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%d</span>", 
                    length(get.cols(k))), "   <div class=\"gaggle-namelist\">", 
                  "      <ol>", paste("<li>", sort(get.cols(k)), 
                    "</li>", sep = "", collapse = ""), "      </ol>", 
                  "   </div>", "</div>", "<p><a href=\"#bicluster%K03d%K_ratios\" onclick=\"toggleVisible('bicluster%K03d%K_ratios'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K ratios.</p>", "<div id=\"bicluster%K03d%K_ratios\" style=\"display:none;\" class=\"gaggle-data ratios\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K ratios</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%dx%d</span>", 
                    length(rows), length(get.cols(k))), "   <div class=\"gaggle-matrix-tsv\">", 
                  "        RATIOS", "   </div>", "</div>", "<p><a href=\"#bicluster%K03d%K_pssm1\" onclick=\"toggleVisible('bicluster%K03d%K_pssm1'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K motif PSSM #1.</p>", 
                  "<div id=\"bicluster%K03d%K_pssm1\" style=\"display:none;\" class=\"gaggle-data ratios\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K motif PSSM #1</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%dx%d</span>", 
                    nrow(meme.scores[[seq.type]][[k]]$meme.out[[1]]$pssm), 
                    ncol(meme.scores[[seq.type]][[k]]$meme.out[[1]]$pssm)), 
                  "   <div class=\"gaggle-matrix-tsv\">", "           MOTIF1", 
                  "   </div>", "</div>", "<p><a href=\"#bicluster%K03d%K_pssm2\" onclick=\"toggleVisible('bicluster%K03d%K_pssm2'); return false;\">[+]</a>", 
                  "Show/hide bicluster #%K motif PSSM #2.</p>", 
                  "<div id=\"bicluster%K03d%K_pssm2\" style=\"display:none;\" class=\"gaggle-data ratios\">", 
                  "   <span class=\"gaggle-name hidden\">bicluster %K motif PSSM #2</span>", 
                  "   <span class=\"gaggle-species hidden\">%SPECIES</span>", 
                  sprintf("   <span class=\"gaggle-size hidden\">%dx%d</span>", 
                    nrow(meme.scores[[seq.type]][[k]]$meme.out[[2]]$pssm), 
                    ncol(meme.scores[[seq.type]][[k]]$meme.out[[2]]$pssm)), 
                  "   <div class=\"gaggle-matrix-tsv\">", "           MOTIF2", 
                  "   </div>", "</div>", "</td></table>", if (pdfs) sprintf("<a href=\"../pdfs/cluster%03d.pdf\">View PDF version</a>", 
                    k) else "", "</html>"), collapse = "\n")
                rm(short.names, long.names, refseq.names, upstream.seqs)
                htmltext <- gsub("%K03d%K", sprintf("%03d", k), 
                  htmltext)
                htmltext <- gsub("%K", k, htmltext)
                htmltext <- gsub("%FILE", cmonkey.filename, htmltext)
                htmltext <- gsub("%SPECIES", gsub("_", " ", rsat.species), 
                  htmltext)
                tmp <- as.data.frame(get.cluster.matrix(rows, 
                  get.cols(k)))
                tmp <- cbind(GENES = rownames(tmp), tmp)
                tf <- tempfile()
                write.table(tmp, file = tf, sep = "\t", quote = F, 
                  row.names = F)
                rm(tmp)
                htmltext <- sub("RATIOS", paste(readLines(tf), 
                  collapse = "\n"), htmltext)
                unlink(tf)
                tmp <- as.data.frame(meme.scores[[seq.type]][[k]]$meme.out[[1]]$pssm)
                if (!is.null(tmp) && nrow(tmp) > 0) {
                  tmp <- cbind(1:nrow(tmp), tmp)
                  colnames(tmp) <- c("POSITION", "A", "C", "G", 
                    "T")
                  write.table(tmp, file = tf, sep = "\t", quote = F, 
                    row.names = F)
                  htmltext <- sub("MOTIF1", paste(readLines(tf), 
                    collapse = "\n"), htmltext)
                  unlink(tf)
                }
                rm(tmp)
                tmp <- as.data.frame(meme.scores[[seq.type]][[k]]$meme.out[[2]]$pssm)
                if (!is.null(tmp) && nrow(tmp) > 0) {
                  tmp <- cbind(1:nrow(tmp), tmp)
                  colnames(tmp) <- c("POSITION", "A", "C", "G", 
                    "T")
                  write.table(tmp, file = tf, sep = "\t", quote = F, 
                    row.names = F)
                  htmltext <- sub("MOTIF2", paste(readLines(tf), 
                    collapse = "\n"), htmltext)
                }
                unlink(tf)
                rm(tmp, tf)
                cat(htmltext, file = sprintf("%s/htmls/cluster%03d.html", 
                  out.dir, k), sep = "\n")
                rm(htmltext)
            }, mc.preschedule = F)
            cat("\n")
        }
        cat("PROFILES: ")
        lapply(1:length(clusterStack), function(k, ...) {
            if (k%%25 == 0) 
                cat(k)
            else cat(".")
            if (file.exists(sprintf("%s/htmls/cluster%03d_profile.png", 
                out.dir, k))) 
                return()
            try({
                png(sprintf("%s/htmls/cluster%03d_profile.png", 
                  out.dir, k), width = 128, height = 64, antialias = "subpixel")
                par(mar = rep(0.5, 4) + 0.1, mgp = c(3, 1, 0) * 
                  0.75)
                c <- get.clust(k)
                plotCluster(c, main = "", no.par = T, ...)
                dev.off()
            })
        })
        cat("\n")
        cat("NETWORKS: ")
        lapply(1:length(clusterStack), function(k, ...) {
            if (k%%25 == 0) 
                cat(k)
            else cat(".")
            if (file.exists(sprintf("%s/htmls/cluster%03d_network.png", 
                out.dir, k))) 
                return()
            try({
                png(sprintf("%s/htmls/cluster%03d_network.png", 
                  out.dir, k), width = 64, height = 64, antialias = "subpixel")
                par(mar = rep(0.5, 4) + 0.1, mgp = c(3, 1, 0) * 
                  0.75)
                c <- get.clust(k)
                plotCluster.network(c, cex = 0.3, no.legend = T, 
                  ...)
                dev.off()
            })
        })
        cat("\n")
        cat("MOTIFS: ")
        lapply(1:length(clusterStack), function(k, ...) {
            if (k%%25 == 0) 
                cat(k)
            else cat(".")
            e.vals <- lapply(meme.scores[[seq.type]][[k]]$meme.out, 
                "[[", "e.value")
            pssms <- lapply(meme.scores[[seq.type]][[k]]$meme.out, 
                "[[", "pssm")
            if (length(pssms) < 2) {
                for (i in (length(pssms) + 1):2) {
                  pssms[[i]] <- matrix(0.25, nrow = 6, ncol = 4)
                  e.vals[[i]] <- Inf
                }
            }
            for (pp in 1:length(pssms)) {
                if (file.exists(sprintf("%s/htmls/cluster%03d_pssm%d.png", 
                  out.dir, k, pp))) 
                  next
                try({
                  png(sprintf("%s/htmls/cluster%03d_pssm%d.png", 
                    out.dir, k, pp), width = 128, height = 64, 
                    antialias = "subpixel")
                  if (is.matrix(pssms[[pp]])) 
                    try(viewPssm(pssms[[pp]], e.val = e.vals[[pp]], 
                      mot.ind = pp), silent = T)
                  dev.off()
                })
            }
        })
        cat("\n")
        cat("MOTIF POSITIONS: ")
        lapply(1:length(clusterStack), function(k, ...) {
            if (k%%25 == 0) 
                cat(k)
            else cat(".")
            if (file.exists(sprintf("%s/htmls/cluster%03d_mot_posns.png", 
                out.dir, k))) 
                return()
            try({
                png(sprintf("%s/htmls/cluster%03d_mot_posns.png", 
                  out.dir, k), width = 128, height = 64, antialias = "subpixel")
                par(mar = rep(0.5, 4) + 0.1, mgp = c(3, 1, 0) * 
                  0.75)
                c <- plotClust(k, dont.plot = T, seq.type = seq.type, 
                  ...)
                plotClusterMotifPositions(c, cex = 0.4, no.key = T, 
                  ...)
                dev.off()
            })
        })
        cat("\n")
        cluster.summ <- cluster.summary(...)
        if (nrow(cluster.summ) <= 0) 
            cluster.summ <- cluster.summary(e.cutoff = Inf, nrow.cutoff = Inf)
        dlf(paste(out.dir, "hwriter.css", sep = "/"), "http://www.ebi.ac.uk/~gpau/hwriter/hwriter.css")
        html <- openPage(paste(out.dir, "/index.html", sep = ""), 
            title = paste("cMonkey bicluster summary for run", 
                cmonkey.filename), link.css = "hwriter.css")
        hwrite(paste("<h2>cMonkey bicluster summary for run", 
            cmonkey.filename, "</h2>"), html)
        hwrite("<ul><li>Download a tab-delimited version of this table", 
            html, link = "cluster.summary.tsv", style = "font-size:75%")
        hwrite("<li>Download a list of each bicluster's gene members", 
            html, link = "cluster.members.genes.txt", style = "font-size:75%")
        hwrite("<li>Download a list of each bicluster's array/condition members", 
            html, link = "cluster.members.arrays.txt", style = "font-size:75%")
        hwrite("<li>Plots of summary statistics of biclustering run", 
            html, link = "svgs/stats.svg", style = "font-size:75%")
        if (save.session) 
            hwrite("<li>Saved cMonkey R session file", html, 
                link = "cm_session.RData", style = "font-size:75%")
        hwrite("<li>Summary of cMonkey input parameters</ul>", 
            html, link = "cm.params.txt", style = "font-size:75%")
        hwrite("<br><center><b>Bicluster summary</b></center><br>", 
            html)
        hwrite("<br><center><b>Click on bicluster link in first column for more info.</b></center><br>", 
            html, style = "font-size:60%")
        himg0 <- hwriteImage(sprintf("htmls/cluster%03d_profile.png", 
            as.integer(rownames(cluster.summ))), table = F)
        himg0a <- hwriteImage(sprintf("htmls/cluster%03d_network.png", 
            as.integer(rownames(cluster.summ))), table = F)
        himg1 <- hwriteImage(sprintf("htmls/cluster%03d_pssm1.png", 
            as.integer(rownames(cluster.summ))), table = F)
        himg2 <- hwriteImage(sprintf("htmls/cluster%03d_pssm2.png", 
            as.integer(rownames(cluster.summ))), table = F)
        himg2a <- hwriteImage(sprintf("htmls/cluster%03d_mot_posns.png", 
            as.integer(rownames(cluster.summ))), table = F)
        cluster.summ$score <- sprintf("%.3f", cluster.summ$score)
        cluster.summ$resid <- sprintf("%.3f", cluster.summ$resid)
        rn <- rownames(cluster.summ)
        cluster.summ <- cbind(n.genes = cluster.summ$nrow, n.arrays = sapply(as.integer(rownames(cluster.summ)), 
            function(i) length(get.cols(i))), score = cluster.summ$score, 
            residual = cluster.summ$resid)
        rownames(cluster.summ) <- rn
        himg3 <- hwrite(sapply(as.integer(rn), function(k) paste(sort(get.rows(k)), 
            collapse = " ")), table = F)
        himg4 <- hwrite(unlist(mc$apply(as.integer(rn), function(k) {
            tmp <- get.long.names(sort(get.rows(k)), short = T)
            tmp <- unique(tmp[!tmp %in% sort(get.rows(k)) & tmp != 
                ""])
            paste(tmp, collapse = " ")
        })), table = F)
        himg5 <- hwrite(unlist(mc$apply(as.integer(rn), function(k) {
            tmp <- get.long.names(sort(get.rows(k)), short = F)
            tmp <- unique(tmp[!tmp %in% sort(get.rows(k)) & tmp != 
                ""])
            paste(tmp, collapse = " | ")
        })), table = F)
        hwrite(cbind(cluster.summ[, 1:4], profile = himg0, network = himg0a, 
            motif1 = himg1, motif2 = himg2, motif.posns = himg2a, 
            probe.names = himg3, short.names = himg4, long.names = himg5), 
            html, table.style = "text-align:center;font-size:70%", 
            row.style = list("font-weight:bold;text-align:center;font-size:70"), 
            col.style = list(orf.names = "font-size:50%", short.names = "font-size:50%", 
                long.names = "font-size:50%"), col.link = list(sprintf("htmls/cluster%03d.html", 
                as.integer(rownames(cluster.summ)))))
        closePage(html, splash = F)
    }
    write.table(cluster.summ, file = paste(out.dir, "/cluster.summary.tsv", 
        sep = ""), quote = F, sep = "\t")
    for (i in sapply(1:k.clust, function(k) c(k, sort(get.rows(k))))) cat(i, 
        "\n", file = paste(out.dir, "/cluster.members.genes.txt", 
            sep = ""), append = T)
    for (i in sapply(1:k.clust, function(k) c(k, sort(get.cols(k))))) cat(i, 
        "\n", file = paste(out.dir, "/cluster.members.arrays.txt", 
            sep = ""), append = T)
    tmp <- capture.output(for (name in ls(cmonkey.params)) {
        cat(name, "= ")
        str(get(name, envir = cmonkey.params), no.list = T)
    })
    cat(tmp, file = paste(out.dir, "/cm.params.txt", sep = ""), 
        sep = "\n", collapse = "\n")
    if (save.session) 
        save.image(file = paste(out.dir, "/cm_session.RData", 
            sep = ""))
}
